/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.LibraryTools;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@DisableCachingByDefault(because="Swift Export is experimental, so no caching for now")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b!\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\b\u0010\u0015\u001a\u00020\u0012H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/MergeStaticLibrariesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "libraries", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraries", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "library", "Lorg/gradle/api/file/RegularFileProperty;", "getLibrary", "()Lorg/gradle/api/file/RegularFileProperty;", "libraryTools", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/LibraryTools;", "getLibraryTools", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/LibraryTools;", "libraryTools$delegate", "Lkotlin/Lazy;", "addLibrary", "", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "mergeLibraries", "kotlin-gradle-plugin_common"})
public abstract class MergeStaticLibrariesTask
extends DefaultTask {
    @NotNull
    private final Lazy libraryTools$delegate;

    public MergeStaticLibrariesTask() {
        this.onlyIf(1.INSTANCE);
        this.libraryTools$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LibraryTools>(this){
            final /* synthetic */ MergeStaticLibrariesTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LibraryTools invoke() {
                return new LibraryTools(this.this$0.getLogger());
            }
        }));
    }

    @SkipWhenEmpty
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getLibraries();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getLibrary();

    private final LibraryTools getLibraryTools() {
        Lazy lazy = this.libraryTools$delegate;
        return (LibraryTools)lazy.getValue();
    }

    public final void addLibrary(@NotNull Provider<File> library2) {
        Intrinsics.checkNotNullParameter(library2, (String)"library");
        Object[] objectArray = new Object[]{library2};
        this.getLibraries().from(objectArray);
    }

    @TaskAction
    public final void mergeLibraries() {
        Set set2 = this.getLibraries().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"libraries.files");
        List inputLibs = CollectionsKt.toList((Iterable)set2);
        File outputLib = FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.getLibrary()));
        this.getLibraryTools().mergeLibraries(inputLibs, outputLib);
    }
}

