/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.kapt.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassDependencies;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.KaptClasspathChanges;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.UnknownSnapshot;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001#BA\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J2\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0017`\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0002J\u0006\u0010\"\u001a\u00020\u001eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot;", "", "cacheDir", "Ljava/io/File;", "classpath", "", "annotationProcessorClasspath", "dataForFiles", "", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathEntryData;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "diff", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/KaptClasspathChanges;", "previousSnapshot", "changedFiles", "", "findAllImpacted", "", "changedClasses", "getAllDataFiles", "", "getHashesToAnalyze", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "filesToLoad", "isCompatible", "", "snapshot", "loadAll", "", "loadEntriesFor", "file", "", "writeToCache", "ClasspathSnapshotFactory", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nClasspathSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshot.kt\norg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1747#2,3:216\n766#2:219\n857#2,2:220\n766#2:222\n857#2,2:223\n766#2:226\n857#2,2:227\n2976#2,5:229\n1855#2,2:234\n1#3:225\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshot.kt\norg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot\n*L\n72#1:216,3\n77#1:219\n77#1:220,2\n78#1:222\n78#1:223,2\n79#1:226\n79#1:227,2\n121#1:229,5\n123#1:234,2\n*E\n"})
public class ClasspathSnapshot {
    @NotNull
    private final File cacheDir;
    @NotNull
    private final List<File> classpath;
    @NotNull
    private final List<File> annotationProcessorClasspath;
    @NotNull
    private final Map<File, ClasspathEntryData> dataForFiles;

    protected ClasspathSnapshot(@NotNull File cacheDir, @NotNull List<? extends File> classpath2, @NotNull List<? extends File> annotationProcessorClasspath, @NotNull Map<File, ClasspathEntryData> dataForFiles) {
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
        Intrinsics.checkNotNullParameter(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
        Intrinsics.checkNotNullParameter(dataForFiles, (String)"dataForFiles");
        this.cacheDir = cacheDir;
        this.classpath = classpath2;
        this.annotationProcessorClasspath = annotationProcessorClasspath;
        this.dataForFiles = dataForFiles;
    }

    @NotNull
    public final Set<File> getAllDataFiles() {
        return this.dataForFiles.keySet();
    }

    private final boolean isCompatible(ClasspathSnapshot snapshot) {
        return !Intrinsics.areEqual((Object)this, (Object)UnknownSnapshot.INSTANCE) && !Intrinsics.areEqual((Object)snapshot, (Object)UnknownSnapshot.INSTANCE) && Intrinsics.areEqual(this.classpath, snapshot.classpath) && Intrinsics.areEqual(this.annotationProcessorClasspath, snapshot.annotationProcessorClasspath);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KaptClasspathChanges diff(@NotNull ClasspathSnapshot previousSnapshot, @NotNull Set<? extends File> changedFiles) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Object element$iv2;
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)previousSnapshot, (String)"previousSnapshot");
            Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
            if (!this.isCompatible(previousSnapshot)) {
                return KaptClasspathChanges.Unknown.INSTANCE;
            }
            Iterable $this$any$iv = this.annotationProcessorClasspath;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    if (!changedFiles.contains(it)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return KaptClasspathChanges.Unknown.INSTANCE;
        }
        Iterable $this$filter$iv = CollectionsKt.intersect((Iterable)this.dataForFiles.keySet(), (Iterable)previousSnapshot.dataForFiles.keySet());
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            File it = (File)element$iv$iv;
            boolean bl3 = false;
            if (!(!changedFiles.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unchangedBetweenCompilations = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = this.dataForFiles.keySet();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            File it = (File)element$iv$iv;
            boolean bl4 = false;
            if (!(!unchangedBetweenCompilations.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable it = $this$filter$iv2 = (List)destination$iv$iv2;
        boolean bl5 = false;
        this.loadEntriesFor(it);
        Iterable currentToLoad = $this$filter$iv2;
        Iterable $this$filter$iv3 = previousSnapshot.dataForFiles.keySet();
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Iterator destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it2 = (File)element$iv$iv;
            boolean bl6 = false;
            if (!(!unchangedBetweenCompilations.contains(it2))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List previousToLoad = (List)((Object)destination$iv$iv3);
        if (!(currentToLoad.size() == previousToLoad.size())) {
            boolean $i$a$-check-ClasspathSnapshot$diff$32 = false;
            String $i$a$-check-ClasspathSnapshot$diff$32 = StringsKt.trimIndent((String)("\n            Number of loaded files in snapshots differs. Reported changed files: " + changedFiles + "\n            Current snapshot data files: " + this.dataForFiles.keySet() + "\n            Previous snapshot data files: " + previousSnapshot.dataForFiles.keySet() + "\n        "));
            throw new IllegalStateException($i$a$-check-ClasspathSnapshot$diff$32.toString());
        }
        HashMap<String, byte[]> currentHashesToAnalyze = this.getHashesToAnalyze((List<? extends File>)currentToLoad);
        HashMap<String, byte[]> previousHashesToAnalyze = previousSnapshot.getHashesToAnalyze(previousToLoad);
        Set changedClasses = new LinkedHashSet();
        Set<String> set2 = previousHashesToAnalyze.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"previousHashesToAnalyze.keys");
        Set<String> set3 = currentHashesToAnalyze.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"currentHashesToAnalyze.keys");
        for (String key : SetsKt.plus(set2, (Iterable)set3)) {
            byte[] previousHash = previousHashesToAnalyze.get(key);
            if (previousHash == null) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                changedClasses.add(key);
                continue;
            }
            byte[] currentHash = currentHashesToAnalyze.get(key);
            if (currentHash == null) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                changedClasses.add(key);
                continue;
            }
            if (Arrays.equals(previousHash, currentHash)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            changedClasses.add(key);
        }
        for (File unchanged : unchangedBetweenCompilations) {
            ClasspathEntryData classpathEntryData = previousSnapshot.dataForFiles.get(unchanged);
            Intrinsics.checkNotNull((Object)classpathEntryData);
            this.dataForFiles.put(unchanged, classpathEntryData);
        }
        Set<String> allImpactedClasses = this.findAllImpacted(changedClasses);
        return new KaptClasspathChanges.Known(allImpactedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, byte[]> getHashesToAnalyze(List<? extends File> filesToLoad) {
        HashMap<String, byte[]> hashMap;
        Iterable $this$sumBy$iv = filesToLoad;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            File file = (File)element$iv;
            int n = sum$iv;
            boolean bl = false;
            ClasspathEntryData classpathEntryData = this.dataForFiles.get(it);
            Intrinsics.checkNotNull((Object)classpathEntryData);
            int n2 = classpathEntryData.getClassAbiHash().size();
            sum$iv = n + n2;
        }
        int hashAbiSize = sum$iv;
        HashMap<String, byte[]> hashes = hashMap = new HashMap<String, byte[]>(hashAbiSize);
        boolean bl = false;
        Iterable $this$forEach$iv = filesToLoad;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            ClasspathEntryData classpathEntryData = this.dataForFiles.get(it);
            Intrinsics.checkNotNull((Object)classpathEntryData);
            hashes.putAll(classpathEntryData.getClassAbiHash());
        }
        return hashMap;
    }

    private final void loadEntriesFor(Iterable<? extends File> file) {
        for (File file2 : file) {
            if (this.dataForFiles.get(file2) != null) continue;
            this.dataForFiles.put(file2, ClasspathEntryData.ClasspathEntrySerializer.INSTANCE.loadFrom(file2));
        }
    }

    private final void loadAll() {
        this.loadEntriesFor((Iterable<? extends File>)this.dataForFiles.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToCache() {
        Object object;
        Object object2;
        this.loadAll();
        File classpathEntries = FilesKt.resolve((File)this.cacheDir, (String)"classpath-entries.bin");
        Closeable closeable = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(classpathEntries)));
        Object object3 = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            it.writeObject(this.classpath);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
        }
        File annotationProcessorClasspathEntries = FilesKt.resolve((File)this.cacheDir, (String)"ap-classpath-entries.bin");
        object3 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(annotationProcessorClasspathEntries)));
        object2 = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object3;
            boolean bl = false;
            it.writeObject(this.annotationProcessorClasspath);
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
        }
        File classpathStructureData = FilesKt.resolve((File)this.cacheDir, (String)"classpath-structure.bin");
        object2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(classpathStructureData)));
        object = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object2;
            boolean bl = false;
            it.writeObject(this.dataForFiles);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
    }

    private final Set<String> findAllImpacted(Set<String> changedClasses) {
        HashMap transitiveDeps = new HashMap();
        HashMap nonTransitiveDeps = new HashMap();
        Iterator<ClasspathEntryData> iterator = this.dataForFiles.values().iterator();
        while (iterator.hasNext()) {
            ClasspathEntryData entry2;
            ClasspathEntryData classpathEntryData = entry2 = iterator.next();
            Intrinsics.checkNotNull((Object)classpathEntryData);
            for (Map.Entry<String, ClassDependencies> object : classpathEntryData.getClassDependencies().entrySet()) {
                boolean bl;
                List it;
                String className = object.getKey();
                ClassDependencies classDependency = object.getValue();
                for (String abiType : classDependency.getAbiTypes()) {
                    List list = (List)transitiveDeps.get(abiType);
                    if (list == null) {
                        list = new LinkedList();
                    }
                    it = list;
                    bl = false;
                    it.add(className);
                    ((Map)transitiveDeps).put(abiType, it);
                }
                for (String privateType : classDependency.getPrivateTypes()) {
                    List list = (List)nonTransitiveDeps.get(privateType);
                    if (list == null) {
                        list = new LinkedList();
                    }
                    it = list;
                    bl = false;
                    it.add(className);
                    ((Map)nonTransitiveDeps).put(privateType, it);
                }
            }
        }
        Set allImpacted = new LinkedHashSet();
        Set current2 = changedClasses;
        while (!((Collection)current2).isEmpty()) {
            Set newRound = new LinkedHashSet();
            for (String klass : current2) {
                List it;
                boolean bl;
                if (!allImpacted.add(klass)) continue;
                if ((List)transitiveDeps.get(klass) != null) {
                    bl = false;
                    newRound.addAll(it);
                }
                if ((List)nonTransitiveDeps.get(klass) == null) continue;
                bl = false;
                allImpacted.addAll(it);
            }
            current2 = newRound;
        }
        return allImpacted;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot$ClasspathSnapshotFactory;", "", "()V", "createCurrent", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot;", "cacheDir", "Ljava/io/File;", "classpath", "", "annotationProcessorClasspath", "allStructureData", "", "getEmptySnapshot", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/UnknownSnapshot;", "loadFrom", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nClasspathSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshot.kt\norg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot$ClasspathSnapshotFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1253#2,4:216\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshot.kt\norg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot$ClasspathSnapshotFactory\n*L\n51#1:216,4\n*E\n"})
    public static final class ClasspathSnapshotFactory {
        @NotNull
        public static final ClasspathSnapshotFactory INSTANCE = new ClasspathSnapshotFactory();

        private ClasspathSnapshotFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ClasspathSnapshot loadFrom(@NotNull File cacheDir) {
            Map map2;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            File classpathEntries = FilesKt.resolve((File)cacheDir, (String)"classpath-entries.bin");
            File classpathStructureData = FilesKt.resolve((File)cacheDir, (String)"classpath-structure.bin");
            File annotationProcessorClasspathEntries = FilesKt.resolve((File)cacheDir, (String)"ap-classpath-entries.bin");
            if (!(classpathEntries.exists() && classpathStructureData.exists() && annotationProcessorClasspathEntries.exists())) {
                return UnknownSnapshot.INSTANCE;
            }
            Closeable closeable = new ObjectInputStream(new BufferedInputStream(new FileInputStream(classpathEntries)));
            Object object3 = null;
            try {
                ObjectInputStream it = (ObjectInputStream)closeable;
                boolean bl = false;
                Object object4 = it.readObject();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                object2 = (List)object4;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
            }
            List classpathFiles = object2;
            object3 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(annotationProcessorClasspathEntries)));
            object2 = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object3;
                boolean bl = false;
                Object object5 = it.readObject();
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                object = (List)object5;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
            }
            List annotationProcessorClasspathFiles = object;
            object2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(classpathStructureData)));
            object = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object2;
                boolean bl = false;
                Object object6 = it.readObject();
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<java.io.File, org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData?>");
                map2 = TypeIntrinsics.asMutableMap((Object)object6);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            Map dataForFiles = map2;
            return new ClasspathSnapshot(cacheDir, classpathFiles, annotationProcessorClasspathFiles, dataForFiles);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClasspathSnapshot createCurrent(@NotNull File cacheDir, @NotNull List<? extends File> classpath2, @NotNull List<? extends File> annotationProcessorClasspath, @NotNull Set<? extends File> allStructureData) {
            void $this$associateTo$iv;
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
            Intrinsics.checkNotNullParameter(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
            Intrinsics.checkNotNullParameter(allStructureData, (String)"allStructureData");
            Iterable iterable = allStructureData;
            Map destination$iv = new HashMap(allStructureData.size());
            boolean $i$f$associateTo = false;
            for (Object element$iv : $this$associateTo$iv) {
                Map map2 = destination$iv;
                File it = (File)element$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, null);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            HashMap data = (HashMap)destination$iv;
            return new ClasspathSnapshot(cacheDir, classpath2, annotationProcessorClasspath, data);
        }

        @NotNull
        public final UnknownSnapshot getEmptySnapshot() {
            return UnknownSnapshot.INSTANCE;
        }
    }
}

