/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.J2ktIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.primitives.UnsignedLongs;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value2) {
        return value2 & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value2) {
        Preconditions.checkArgument(value2 >> 8 == 0L, "out of range: %s", value2);
        return (byte)value2;
    }

    public static byte saturatedCast(long value2) {
        if (value2 > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value2 < 0L) {
            return 0;
        }
        return (byte)value2;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt(a) - UnsignedBytes.toInt(b);
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min = UnsignedBytes.toInt(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            int next = UnsignedBytes.toInt(array2[i2]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max = UnsignedBytes.toInt(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            int next = UnsignedBytes.toInt(array2[i2]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    public static String toString(byte x) {
        return UnsignedBytes.toString(x, 10);
    }

    public static String toString(byte x, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString(UnsignedBytes.toInt(x), radix);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt(Preconditions.checkNotNull(string), radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException("out of range: " + parse);
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt(array2[0]));
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(UnsignedBytes.toString(array2[i2]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b) {
        return (byte)(b ^ 0x80);
    }

    public static void sort(byte[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedBytes.sort(array2, 0, array2.length);
    }

    public static void sort(byte[] array2, int fromIndex, int toIndex) {
        int i2;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array2[i2] = UnsignedBytes.flip(array2[i2]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array2[i2] = UnsignedBytes.flip(array2[i2]);
        }
    }

    public static void sortDescending(byte[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedBytes.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(byte[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        while (i2 < toIndex) {
            int n = i2++;
            array2[n] = (byte)(array2[n] ^ 0x7F);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i2 = fromIndex;
        while (i2 < toIndex) {
            int n = i2++;
            array2[n] = (byte)(array2[n] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                ?[] constants = Objects.requireNonNull(theClass.getEnumConstants());
                Comparator comparator = (Comparator)constants[0];
                return comparator;
            }
            catch (Throwable t) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i2 = 0; i2 < minLength; ++i2) {
                    int result2 = UnsignedBytes.compare(left[i2], right[i2]);
                    if (result2 == 0) continue;
                    return result2;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                            @Override
                            public Unsafe run() throws Exception {
                                Class<Unsafe> k = Unsafe.class;
                                for (Field f : k.getDeclaredFields()) {
                                    f.setAccessible(true);
                                    Object x = f.get(null);
                                    if (!k.isInstance(x)) continue;
                                    return (Unsafe)k.cast(x);
                                }
                                throw new NoSuchFieldError("the Unsafe");
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] left, byte[] right) {
                int i2;
                int stride = 8;
                int minLength = Math.min(left.length, right.length);
                int strideLimit = minLength & ~(stride - 1);
                for (i2 = 0; i2 < strideLimit; i2 += stride) {
                    long rw;
                    long lw = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i2);
                    if (lw == (rw = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i2))) continue;
                    if (BIG_ENDIAN) {
                        return UnsignedLongs.compare(lw, rw);
                    }
                    int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
                    return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
                }
                while (i2 < minLength) {
                    int result2 = UnsignedBytes.compare(left[i2], right[i2]);
                    if (result2 != 0) {
                        return result2;
                    }
                    ++i2;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!"64".equals(System.getProperty("sun.arch.data.model")) || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }
}

