/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithNavigationSubstitute;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.synthetic.SyntheticMemberDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u000eH\u0003J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorToSourceUtils;", "", "<init>", "()V", "collectEffectiveReferencedDescriptors", "", "result", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "getEffectiveReferencedDescriptors", "", "getSourceForExtensionReceiverParameterDescriptor", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getSourceFromDescriptor", "getSourceFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "descriptorToDeclaration", "getContainingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "declarationDescriptor", "findTopLevelParent", "frontend"})
@SourceDebugExtension(value={"SMAP\nDescriptorToSourceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DescriptorToSourceUtils.kt\norg/jetbrains/kotlin/resolve/DescriptorToSourceUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class DescriptorToSourceUtils {
    @NotNull
    public static final DescriptorToSourceUtils INSTANCE = new DescriptorToSourceUtils();

    private DescriptorToSourceUtils() {
    }

    private final void collectEffectiveReferencedDescriptors(List<DeclarationDescriptor> result2, DeclarationDescriptor descriptor) {
        if (descriptor instanceof DeclarationDescriptorWithNavigationSubstitute) {
            this.collectEffectiveReferencedDescriptors(result2, ((DeclarationDescriptorWithNavigationSubstitute)descriptor).getSubstitute());
            return;
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor.Kind kind = ((CallableMemberDescriptor)descriptor).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"getKind(...)");
            CallableMemberDescriptor.Kind kind2 = kind;
            if (kind2 != CallableMemberDescriptor.Kind.DECLARATION && kind2 != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor).getOverriddenDescriptors()) {
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor.getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor2, (String)"getOriginal(...)");
                    this.collectEffectiveReferencedDescriptors(result2, callableMemberDescriptor2);
                }
                return;
            }
            if (descriptor instanceof SyntheticMemberDescriptor) {
                this.collectEffectiveReferencedDescriptors(result2, (DeclarationDescriptor)((SyntheticMemberDescriptor)((Object)descriptor)).getBaseDescriptorForSynthetic());
                return;
            }
        }
        result2.add(descriptor);
    }

    @JvmStatic
    @NotNull
    public static final Collection<DeclarationDescriptor> getEffectiveReferencedDescriptors(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ArrayList result2 = new ArrayList();
        List list = result2;
        DeclarationDescriptor declarationDescriptor = descriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        INSTANCE.collectEffectiveReferencedDescriptors(list, declarationDescriptor);
        return result2;
    }

    @JvmStatic
    private static final PsiElement getSourceForExtensionReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor) {
        if (!Intrinsics.areEqual((Object)descriptor.getSource(), (Object)SourceElement.NO_SOURCE) || !(descriptor.getValue() instanceof ExtensionReceiver)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            return null;
        }
        CallableDescriptor containingDeclaration = callableDescriptor;
        SourceElement sourceElement = containingDeclaration.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtCallableDeclaration ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration psi = ktCallableDeclaration;
        return psi.getReceiverTypeReference();
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getSourceFromDescriptor(@NotNull DeclarationDescriptor descriptor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor instanceof ReceiverParameterDescriptor) {
            PsiElement psiElement = DescriptorToSourceUtils.getSourceForExtensionReceiverParameterDescriptor((ReceiverParameterDescriptor)descriptor);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                return it;
            }
        }
        return (object = descriptor instanceof DeclarationDescriptorWithSource ? (DeclarationDescriptorWithSource)descriptor : null) != null && (object = object.getSource()) != null ? PsiSourceElementKt.getPsi((SourceElement)object) : null;
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry getSourceFromAnnotation(@NotNull AnnotationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = PsiSourceElementKt.getPsi(descriptor.getSource());
        return psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement descriptorToDeclaration(@NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Collection<DeclarationDescriptor> effectiveReferencedDescriptors = DescriptorToSourceUtils.getEffectiveReferencedDescriptors(descriptor);
        if (effectiveReferencedDescriptors.size() == 1) {
            Object object = CollectionsKt.firstOrNull((Iterable)effectiveReferencedDescriptors);
            Intrinsics.checkNotNull((Object)object);
            psiElement = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)object);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @JvmStatic
    @Nullable
    public static final KtFile getContainingFile(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"declarationDescriptor");
        DeclarationDescriptor declarationDescriptor2 = INSTANCE.findTopLevelParent(declarationDescriptor);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor descriptor = declarationDescriptor2;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        if (psiElement == null) {
            return null;
        }
        PsiElement declaration = psiElement;
        PsiFile psiFile = declaration.getContainingFile();
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    private final DeclarationDescriptor findTopLevelParent(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor descriptor = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = descriptor;
            Intrinsics.checkNotNull((Object)declarationDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
            descriptor = ((PropertyAccessorDescriptor)declarationDescriptor2).getCorrespondingProperty();
        }
        while (descriptor != null && !DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            descriptor = descriptor.getContainingDeclaration();
        }
        return descriptor;
    }
}

