/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.signature;

import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;
import org.jetbrains.org.objectweb.asm.signature.SignatureWriter;
import org.jetbrains.org.objectweb.asm.util.CheckSignatureAdapter;

public class BothSignatureWriter
extends JvmSignatureWriter {
    private final SignatureWriter signatureWriter;
    private final SignatureVisitor signatureVisitor;
    private boolean generic;
    private final Stack<SignatureVisitor> visitors;

    public BothSignatureWriter(@NotNull Mode mode) {
        if (mode == null) {
            BothSignatureWriter.$$$reportNull$$$0(0);
        }
        this.signatureWriter = new SignatureWriter();
        this.generic = false;
        this.visitors = new Stack();
        this.signatureVisitor = mode.asmType != null ? new CheckSignatureAdapter(mode.asmType, this.signatureWriter) : this.signatureWriter;
    }

    private void push(SignatureVisitor visitor2) {
        this.visitors.push(visitor2);
    }

    private void pop() {
        this.visitors.pop();
    }

    private SignatureVisitor signatureVisitor() {
        return !this.visitors.isEmpty() ? this.visitors.peek() : this.signatureVisitor;
    }

    @Override
    public void writeAsmType(@NotNull Type asmType) {
        if (asmType == null) {
            BothSignatureWriter.$$$reportNull$$$0(1);
        }
        if (asmType.getSort() != 10 && asmType.getSort() != 9) {
            this.signatureVisitor().visitBaseType(asmType.getDescriptor().charAt(0));
        }
        super.writeAsmType(asmType);
    }

    @Override
    public void writeClassBegin(Type asmType) {
        this.signatureVisitor().visitClassType(asmType.getInternalName());
        super.writeClassBegin(asmType);
    }

    @Override
    public void writeOuterClassBegin(Type resultingAsmType, String outerInternalName) {
        this.signatureVisitor().visitClassType(outerInternalName);
        super.writeOuterClassBegin(resultingAsmType, outerInternalName);
    }

    @Override
    public void writeInnerClass(String name2) {
        this.signatureVisitor().visitInnerClassType(name2);
        super.writeInnerClass(name2);
    }

    @Override
    public void writeClassEnd() {
        this.signatureVisitor().visitEnd();
        super.writeClassEnd();
    }

    @Override
    public void writeArrayType() {
        this.push(this.signatureVisitor().visitArrayType());
        super.writeArrayType();
    }

    @Override
    public void writeArrayEnd() {
        this.pop();
        super.writeArrayEnd();
    }

    private static char toJvmVariance(@NotNull Variance variance) {
        if (variance == null) {
            BothSignatureWriter.$$$reportNull$$$0(2);
        }
        switch (variance) {
            case INVARIANT: {
                return '=';
            }
            case IN_VARIANCE: {
                return '-';
            }
            case OUT_VARIANCE: {
                return '+';
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    @Override
    public void writeTypeArgument(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            BothSignatureWriter.$$$reportNull$$$0(3);
        }
        this.push(this.signatureVisitor().visitTypeArgument(BothSignatureWriter.toJvmVariance(projectionKind)));
        this.generic = true;
        super.writeTypeArgument(projectionKind);
    }

    @Override
    public void writeUnboundedWildcard() {
        this.signatureVisitor().visitTypeArgument();
        this.generic = true;
        super.writeUnboundedWildcard();
    }

    @Override
    public void writeTypeArgumentEnd() {
        this.pop();
        super.writeTypeArgumentEnd();
    }

    @Override
    public void writeTypeVariable(@NotNull Name name2, @NotNull Type asmType) {
        if (name2 == null) {
            BothSignatureWriter.$$$reportNull$$$0(4);
        }
        if (asmType == null) {
            BothSignatureWriter.$$$reportNull$$$0(5);
        }
        this.signatureVisitor().visitTypeVariable(name2.asString());
        this.generic = true;
        super.writeTypeVariable(name2, asmType);
    }

    @Override
    public void writeFormalTypeParameter(String name2) {
        this.signatureVisitor().visitFormalTypeParameter(name2);
        this.generic = true;
        super.writeFormalTypeParameter(name2);
    }

    @Override
    public void writeClassBound() {
        this.push(this.signatureVisitor().visitClassBound());
        super.writeClassBound();
    }

    @Override
    public void writeClassBoundEnd() {
        this.pop();
        super.writeClassBoundEnd();
    }

    @Override
    public void writeInterfaceBound() {
        this.push(this.signatureVisitor().visitInterfaceBound());
        super.writeInterfaceBound();
    }

    @Override
    public void writeInterfaceBoundEnd() {
        this.pop();
        super.writeInterfaceBoundEnd();
    }

    @Override
    public void writeParametersStart() {
        super.writeParametersStart();
    }

    @Override
    public void writeParameterType(JvmMethodParameterKind parameterKind) {
        if (parameterKind.isSkippedInGenericSignature()) {
            this.generic = true;
            this.push(new SignatureWriter());
        } else {
            this.push(this.signatureVisitor().visitParameterType());
        }
        super.writeParameterType(parameterKind);
    }

    @Override
    public void writeParameterTypeEnd() {
        this.pop();
        super.writeParameterTypeEnd();
    }

    @Override
    public void writeReturnType() {
        this.push(this.signatureVisitor().visitReturnType());
        super.writeReturnType();
    }

    @Override
    public void writeReturnTypeEnd() {
        this.pop();
        super.writeReturnTypeEnd();
    }

    @Override
    public void writeSuperclass() {
        this.push(this.signatureVisitor().visitSuperclass());
        super.writeSuperclass();
    }

    @Override
    public void writeSuperclassEnd() {
        this.pop();
        super.writeSuperclassEnd();
    }

    @Override
    public void writeInterface() {
        this.push(this.signatureVisitor().visitInterface());
        super.writeInterface();
    }

    @Override
    public void writeInterfaceEnd() {
        this.pop();
        super.writeInterfaceEnd();
    }

    @Override
    @Nullable
    public String makeJavaGenericSignature() {
        return this.generic ? this.signatureWriter.toString() : null;
    }

    @Override
    public boolean skipGenericSignature() {
        return false;
    }

    @Override
    public String toString() {
        return this.signatureWriter.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/signature/BothSignatureWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeAsmType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toJvmVariance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTypeArgument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTypeVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Mode {
        METHOD(1),
        CLASS(0),
        TYPE(2),
        SKIP_CHECKS(null);

        private final Integer asmType;

        private Mode(Integer asmType) {
            this.asmType = asmType;
        }
    }
}

