/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExecutionCallback;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActionCallback
implements Disposable {
    public static final ActionCallback DONE = new Done();
    public static final ActionCallback REJECTED = new Rejected();
    private final ExecutionCallback myDone;
    private final ExecutionCallback myRejected;
    private final String myName;

    public ActionCallback() {
        this(null);
    }

    public ActionCallback(@NonNls String name) {
        this.myName = name;
        this.myDone = new ExecutionCallback();
        this.myRejected = new ExecutionCallback();
    }

    private ActionCallback(@NotNull ExecutionCallback done2, @NotNull ExecutionCallback rejected) {
        if (done2 == null) {
            ActionCallback.$$$reportNull$$$0(0);
        }
        if (rejected == null) {
            ActionCallback.$$$reportNull$$$0(1);
        }
        this.myDone = done2;
        this.myRejected = rejected;
        this.myName = null;
    }

    public void setDone() {
        if (this.myDone.setExecuted()) {
            this.myRejected.clear();
            Disposer.dispose(this);
        }
    }

    @NonNls
    public String toString() {
        String name = this.myName != null ? this.myName : super.toString();
        return name + " done=[" + this.myDone + "] rejected=[" + this.myRejected + "]";
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejected";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ActionCallback";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ActionCallback";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenDone";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenRejected";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenProcessed";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processOnDone";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetDoneRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doWhenDone";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doWhenRejected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWhenProcessed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyWhenDone";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyWhenRejected";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processOnDone";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreExecutionCallback
    extends ExecutionCallback {
        private IgnoreExecutionCallback() {
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }
    }

    private static class ExecutedExecutionCallback
    extends ExecutionCallback {
        ExecutedExecutionCallback() {
            super(0);
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }
    }

    public static class Rejected
    extends ActionCallback {
        public Rejected() {
            super(new IgnoreExecutionCallback(), new ExecutedExecutionCallback());
        }
    }

    public static class Done
    extends ActionCallback {
        public Done() {
            super(new ExecutedExecutionCallback(), new IgnoreExecutionCallback());
        }
    }
}

