/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReceiver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceAdaptation;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceCandidate;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.resolve.calls.components.InputOutputTypes;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.SuspendConversionStrategy;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.AdaptedCallableReferenceIsUsedWithReflection;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceNotCompatible;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferencesDefaultArgumentUsed;
import org.jetbrains.kotlin.resolve.calls.model.FakeKotlinCallArgumentForCallableReference;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.NotCallableMemberReference;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.HiddenDescriptor;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.SimpleScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.DetailedReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001JBW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001e\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0004\u0012\u00020\f0\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JD\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*J\"\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u0010$\u001a\u0004\u0018\u000100H\u0016J.\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010 \u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000206H\u0002J,\u0010:\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u0002042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u00109\u001a\u0002062\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001fH\u0002J\u001a\u0010>\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u001f2\u0006\u0010?\u001a\u00020!H\u0002J\u0018\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020<H\u0002J6\u0010C\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010D\u0012\u0004\u0012\u00020E0\u001e2\u0006\u0010F\u001a\u00020D2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020E2\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R)\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferencesCandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "compatibilityChecker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "csBuilder", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "(Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;)V", "getArgument", "()Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "getCallComponents", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "getCompatibilityChecker", "()Lkotlin/jvm/functions/Function1;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/UnwrappedType;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "buildReflectionType", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceAdaptation;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "dispatchReceiver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;", "extensionReceiver", "builtins", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "createCallableProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/SimpleScopeTowerProcessor;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/DetailedReceiver;", "createCandidate", "towerCandidate", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "createFakeArgumentsForReference", "", "Lorg/jetbrains/kotlin/resolve/calls/model/FakeKotlinCallArgumentForCallableReference;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expectedArgumentCount", "", "inputOutputTypes", "Lorg/jetbrains/kotlin/resolve/calls/components/InputOutputTypes;", "unboundReceiverCount", "getCallableReferenceAdaptation", "hasNonTrivialAdaptation", "", "callableReferenceAdaptation", "needCompatibilityResolveForCallableReference", "candidate", "toCallableReceiver", "receiver", "isExplicit", "varargParameterTypeByExpectedParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferencesCandidateFactory$VarargMappingState;", "expectedParameterType", "substitutedParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "varargMappingState", "VarargMappingState", "resolution"})
public final class CallableReferencesCandidateFactory
implements CandidateFactory<CallableReferenceCandidate> {
    @NotNull
    private final CallableReferenceKotlinCallArgument argument;
    @NotNull
    private final KotlinCallComponents callComponents;
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final Function1<Function1<? super ConstraintSystemOperation, Unit>, Unit> compatibilityChecker;
    @Nullable
    private final UnwrappedType expectedType;
    @NotNull
    private final ConstraintSystemOperation csBuilder;
    @NotNull
    private final KotlinResolutionCallbacks resolutionCallbacks;

    public CallableReferencesCandidateFactory(@NotNull CallableReferenceKotlinCallArgument argument2, @NotNull KotlinCallComponents callComponents, @NotNull ImplicitScopeTower scopeTower, @NotNull Function1<? super Function1<? super ConstraintSystemOperation, Unit>, Unit> compatibilityChecker, @Nullable UnwrappedType expectedType2, @NotNull ConstraintSystemOperation csBuilder, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        Intrinsics.checkNotNullParameter((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkNotNullParameter(compatibilityChecker, (String)"compatibilityChecker");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        this.argument = argument2;
        this.callComponents = callComponents;
        this.scopeTower = scopeTower;
        this.compatibilityChecker = compatibilityChecker;
        this.expectedType = expectedType2;
        this.csBuilder = csBuilder;
        this.resolutionCallbacks = resolutionCallbacks;
    }

    @NotNull
    public final CallableReferenceKotlinCallArgument getArgument() {
        return this.argument;
    }

    @NotNull
    public final KotlinCallComponents getCallComponents() {
        return this.callComponents;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final Function1<Function1<? super ConstraintSystemOperation, Unit>, Unit> getCompatibilityChecker() {
        return this.compatibilityChecker;
    }

    @Nullable
    public final UnwrappedType getExpectedType() {
        return this.expectedType;
    }

    @NotNull
    public final SimpleScopeTowerProcessor<CallableReferenceCandidate> createCallableProcessor(@Nullable DetailedReceiver explicitReceiver) {
        return ScopeTowerProcessorsKt.createCallableReferenceProcessor(this.scopeTower, this.argument.getRhsName(), this, explicitReceiver);
    }

    @Override
    @NotNull
    public CallableReferenceCandidate createCandidate(@NotNull CandidateWithBoundDispatchReceiver towerCandidate, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable ReceiverValueWithSmartCastInfo extensionReceiver) {
        CallableReceiver callableReceiver;
        ReceiverValueWithSmartCastInfo it;
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo;
        CallableReceiver callableReceiver2;
        Intrinsics.checkNotNullParameter((Object)towerCandidate, (String)"towerCandidate");
        Intrinsics.checkNotNullParameter((Object)((Object)explicitReceiverKind), (String)"explicitReceiverKind");
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo2 = towerCandidate.getDispatchReceiver();
        if (receiverValueWithSmartCastInfo2 == null) {
            callableReceiver2 = null;
        } else {
            it = receiverValueWithSmartCastInfo = receiverValueWithSmartCastInfo2;
            boolean bl = false;
            callableReceiver2 = this.toCallableReceiver(it, explicitReceiverKind == ExplicitReceiverKind.DISPATCH_RECEIVER);
        }
        CallableReceiver dispatchCallableReceiver = callableReceiver2;
        receiverValueWithSmartCastInfo = extensionReceiver;
        if (receiverValueWithSmartCastInfo == null) {
            callableReceiver = null;
        } else {
            ReceiverValueWithSmartCastInfo it2 = it = receiverValueWithSmartCastInfo;
            boolean bl = false;
            callableReceiver = this.toCallableReceiver(it2, explicitReceiverKind == ExplicitReceiverKind.EXTENSION_RECEIVER);
        }
        CallableReceiver extensionCallableReceiver = callableReceiver;
        CallableDescriptor candidateDescriptor = towerCandidate.getDescriptor();
        SmartList<KotlinCallDiagnostic> diagnostics2 = new SmartList<KotlinCallDiagnostic>();
        Pair<UnwrappedType, CallableReferenceAdaptation> pair = this.buildReflectionType(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, this.expectedType, this.callComponents.getBuiltIns());
        UnwrappedType reflectionCandidateType = (UnwrappedType)pair.component1();
        CallableReferenceAdaptation callableReferenceAdaptation = (CallableReferenceAdaptation)pair.component2();
        if (this.callComponents.getStatelessCallbacks().isHiddenInResolution((DeclarationDescriptor)candidateDescriptor, this.argument, this.resolutionCallbacks)) {
            diagnostics2.add(HiddenDescriptor.INSTANCE);
            return CallableReferencesCandidateFactory.createCandidate$createReferenceCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, diagnostics2);
        }
        if (this.needCompatibilityResolveForCallableReference(callableReferenceAdaptation, candidateDescriptor)) {
            ResolutionCandidateKt.markCandidateForCompatibilityResolve(this, diagnostics2);
        }
        if (callableReferenceAdaptation != null && this.expectedType != null && this.hasNonTrivialAdaptation(callableReferenceAdaptation) && !FunctionTypesKt.isFunctionType(this.expectedType) && !FunctionTypesKt.isSuspendFunctionType(this.expectedType)) {
            diagnostics2.add(new AdaptedCallableReferenceIsUsedWithReflection(this.argument));
        }
        if (callableReferenceAdaptation != null && callableReferenceAdaptation.getDefaults() != 0 && !this.callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.FunctionReferenceWithDefaultValueAsOtherType)) {
            diagnostics2.add(new CallableReferencesDefaultArgumentUsed(this.argument, candidateDescriptor, callableReferenceAdaptation.getDefaults()));
        }
        if (!(candidateDescriptor instanceof CallableMemberDescriptor)) {
            return new CallableReferenceCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, CollectionsKt.listOf((Object)new NotCallableMemberReference(this.argument, candidateDescriptor)));
        }
        diagnostics2.addAll((Collection<KotlinCallDiagnostic>)towerCandidate.getDiagnostics());
        this.compatibilityChecker.invoke((Object)new Function1<ConstraintSystemOperation, Unit>(this, dispatchCallableReceiver, extensionCallableReceiver, candidateDescriptor, reflectionCandidateType, diagnostics2){
            final /* synthetic */ CallableReferencesCandidateFactory this$0;
            final /* synthetic */ CallableReceiver $dispatchCallableReceiver;
            final /* synthetic */ CallableReceiver $extensionCallableReceiver;
            final /* synthetic */ CallableDescriptor $candidateDescriptor;
            final /* synthetic */ UnwrappedType $reflectionCandidateType;
            final /* synthetic */ SmartList<KotlinCallDiagnostic> $diagnostics;
            {
                this.this$0 = $receiver;
                this.$dispatchCallableReceiver = $dispatchCallableReceiver;
                this.$extensionCallableReceiver = $extensionCallableReceiver;
                this.$candidateDescriptor = $candidateDescriptor;
                this.$reflectionCandidateType = $reflectionCandidateType;
                this.$diagnostics = $diagnostics;
                super(1);
            }

            public final void invoke(@NotNull ConstraintSystemOperation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getHasContradiction()) {
                    return;
                }
                Pair<FreshVariableNewTypeSubstitutor, KotlinCallDiagnostic> pair = CallableReferenceResolutionKt.checkCallableReference(it, this.this$0.getArgument(), this.$dispatchCallableReceiver, this.$extensionCallableReceiver, this.$candidateDescriptor, this.$reflectionCandidateType, this.this$0.getExpectedType(), this.this$0.getScopeTower().getLexicalScope().getOwnerDescriptor());
                KotlinCallDiagnostic visibilityError = (KotlinCallDiagnostic)pair.component2();
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)this.$diagnostics, visibilityError);
                if (it.getHasContradiction()) {
                    this.$diagnostics.add(new CallableReferenceNotCompatible(this.this$0.getArgument(), (CallableMemberDescriptor)this.$candidateDescriptor, this.this$0.getExpectedType(), this.$reflectionCandidateType));
                }
            }
        });
        return CallableReferencesCandidateFactory.createCandidate$createReferenceCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, diagnostics2);
    }

    private final boolean needCompatibilityResolveForCallableReference(CallableReferenceAdaptation callableReferenceAdaptation, CallableDescriptor candidate2) {
        DeclarationDescriptor declarationDescriptor = candidate2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"candidate.containingDeclaration");
        if (DescriptorUtilsKt.isCompanionObject(declarationDescriptor) && this.argument.getLhsResult() instanceof LHSResult.Type) {
            return true;
        }
        if (callableReferenceAdaptation == null) {
            return false;
        }
        return this.hasNonTrivialAdaptation(callableReferenceAdaptation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNonTrivialAdaptation(CallableReferenceAdaptation callableReferenceAdaptation) {
        ResolvedCallArgument it;
        if (callableReferenceAdaptation.getDefaults() != 0) return true;
        if (callableReferenceAdaptation.getSuspendConversionStrategy() != SuspendConversionStrategy.NO_CONVERSION) return true;
        if (callableReferenceAdaptation.getCoercionStrategy() != CoercionStrategy.NO_COERCION) return true;
        Iterable $this$any$iv = callableReferenceAdaptation.getMappedArguments().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ResolvedCallArgument)element$iv;
            boolean bl = false;
        } while (!(it instanceof ResolvedCallArgument.VarargArgument));
        return true;
    }

    private final CallableReferenceAdaptation getCallableReferenceAdaptation(FunctionDescriptor descriptor2, UnwrappedType expectedType2, int unboundReceiverCount, KotlinBuiltIns builtins) {
        boolean bl;
        Object $this$any$iv;
        Object valueParameter2;
        KotlinType[] mappedArgumentTypes;
        LinkedHashMap mappedVarargElements;
        LinkedHashMap<ValueParameterDescriptor, ResolvedCallArgument.VarargArgument> mappedArguments;
        int defaults;
        InputOutputTypes inputOutputTypes;
        block24: {
            boolean bl2;
            ArgumentsToParametersMapper.ArgumentMapping argumentMapping;
            List<FakeKotlinCallArgumentForCallableReference> fakeArguments;
            block23: {
                if (this.callComponents.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) < 0) {
                    return null;
                }
                if (expectedType2 == null) {
                    return null;
                }
                if (ReflectionTypes.Companion.hasKCallableTypeFqName(expectedType2)) {
                    return null;
                }
                InputOutputTypes inputOutputTypes2 = CallableReferenceResolutionKt.extractInputOutputTypesFromCallableReferenceExpectedType(expectedType2);
                if (inputOutputTypes2 == null) {
                    return null;
                }
                inputOutputTypes = inputOutputTypes2;
                int expectedArgumentCount = inputOutputTypes.getInputTypes().size() - unboundReceiverCount;
                if (expectedArgumentCount < 0) {
                    return null;
                }
                fakeArguments = this.createFakeArgumentsForReference(descriptor2, expectedArgumentCount, inputOutputTypes, unboundReceiverCount);
                argumentMapping = this.callComponents.getArgumentsToParametersMapper().mapArguments(fakeArguments, null, descriptor2);
                Iterable $this$any$iv2 = argumentMapping.getDiagnostics();
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        KotlinCallDiagnostic it = (KotlinCallDiagnostic)element$iv;
                        boolean bl3 = false;
                        if (!(!CandidateApplicabilityKt.isSuccess(it.getCandidateApplicability()))) continue;
                        bl2 = true;
                        break block23;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return null;
            }
            defaults = 0;
            VarargMappingState varargMappingState = VarargMappingState.UNMAPPED;
            mappedArguments = new LinkedHashMap<ValueParameterDescriptor, ResolvedCallArgument.VarargArgument>();
            mappedVarargElements = new LinkedHashMap();
            mappedArgumentTypes = new KotlinType[fakeArguments.size()];
            Iterator<KotlinCallArgument> iterator2 = argumentMapping.getParameterToCallArgumentMap();
            Iterator<Map.Entry<ValueParameterDescriptor, ResolvedCallArgument>> bl3 = iterator2.entrySet().iterator();
            while (bl3.hasNext()) {
                Iterator<KotlinCallArgument> iterator3 = iterator2 = bl3.next();
                valueParameter2 = (ValueParameterDescriptor)iterator3.getKey();
                Object object = iterator2;
                ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)object.getValue();
                for (KotlinCallArgument fakeArgument : resolvedArgument.getArguments()) {
                    int index2 = ((FakeKotlinCallArgumentForCallableReference)fakeArgument).getIndex();
                    Pair<KotlinType, VarargMappingState> pair = descriptor2.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(pair, (String)"descriptor.valueParameters");
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.getOrNull(pair, (int)valueParameter2.getIndex());
                    if (valueParameterDescriptor == null) continue;
                    ValueParameterDescriptor substitutedParameter = valueParameterDescriptor;
                    KotlinType mappedArgument = null;
                    if (ArgumentsUtilsKt.isVararg(substitutedParameter)) {
                        VarargMappingState newVarargMappingState;
                        pair = this.varargParameterTypeByExpectedParameter(inputOutputTypes.getInputTypes().get(index2 + unboundReceiverCount), substitutedParameter, varargMappingState, builtins);
                        KotlinType varargType = (KotlinType)pair.component1();
                        varargMappingState = newVarargMappingState = (VarargMappingState)((Object)pair.component2());
                        mappedArgument = varargType;
                        VarargMappingState varargMappingState2 = newVarargMappingState;
                        int n = WhenMappings.$EnumSwitchMapping$0[varargMappingState2.ordinal()];
                        switch (n) {
                            case 1: {
                                Map map = mappedArguments;
                                ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(fakeArgument);
                                map.put(valueParameter2, simpleArgument);
                                break;
                            }
                            case 2: {
                                Object object2;
                                Map $this$getOrPut$iv = mappedVarargElements;
                                boolean $i$f$getOrPut = false;
                                Object value$iv = $this$getOrPut$iv.get(valueParameter2);
                                if (value$iv == null) {
                                    boolean bl4 = false;
                                    List answer$iv = new ArrayList();
                                    $this$getOrPut$iv.put(valueParameter2, answer$iv);
                                    object2 = answer$iv;
                                } else {
                                    object2 = value$iv;
                                }
                                ((List)object2).add(fakeArgument);
                            }
                        }
                    } else {
                        mappedArgument = substitutedParameter.getType();
                        pair = mappedArguments;
                        pair.put((KotlinType)valueParameter2, (VarargMappingState)((Object)resolvedArgument));
                    }
                    mappedArgumentTypes[index2] = mappedArgument;
                }
                if (!Intrinsics.areEqual((Object)resolvedArgument, (Object)ResolvedCallArgument.DefaultArgument.INSTANCE)) continue;
                int n = defaults;
                defaults = n + 1;
                object = mappedArguments;
                object.put(valueParameter2, resolvedArgument);
            }
            $this$any$iv = mappedArgumentTypes;
            boolean $i$f$any = false;
            valueParameter2 = $this$any$iv;
            int n = ((KotlinType[])valueParameter2).length;
            for (int resolvedArgument = 0; resolvedArgument < n; ++resolvedArgument) {
                KotlinType element$iv = valueParameter2[resolvedArgument];
                KotlinType it = element$iv;
                boolean bl5 = false;
                if (!(it == null)) continue;
                bl = true;
                break block24;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object $i$f$any = mappedVarargElements;
        $this$any$iv = $i$f$any.entrySet().iterator();
        while ($this$any$iv.hasNext()) {
            Object resolvedArgument = $i$f$any = (Map.Entry)$this$any$iv.next();
            valueParameter2 = (ValueParameterDescriptor)resolvedArgument.getKey();
            Object object = $i$f$any;
            List varargElements = (List)object.getValue();
            object = mappedArguments;
            ResolvedCallArgument.VarargArgument varargArgument = new ResolvedCallArgument.VarargArgument(varargElements);
            object.put(valueParameter2, varargArgument);
        }
        for (ValueParameterDescriptor valueParameter3 : descriptor2.getValueParameters()) {
            Intrinsics.checkNotNullExpressionValue((Object)valueParameter3, (String)"valueParameter");
            if (!ArgumentsUtilsKt.isVararg(valueParameter3)) continue;
            mappedArguments.putIfAbsent(valueParameter3.getOriginal(), new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
        }
        UnwrappedType returnExpectedType = inputOutputTypes.getOutputType();
        CoercionStrategy coercion = TypeUtilsKt.isUnit(returnExpectedType) && ((valueParameter2 = descriptor2.getReturnType()) == null ? false : !TypeUtilsKt.isUnit((KotlinType)valueParameter2)) ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
        Map adaptedArguments = ReflectionTypes.Companion.isBaseTypeForNumberedReferenceTypes(expectedType2) ? MapsKt.emptyMap() : (Map)mappedArguments;
        SuspendConversionStrategy suspendConversionStrategy = !descriptor2.isSuspend() && FunctionTypesKt.isSuspendFunctionType(expectedType2) ? SuspendConversionStrategy.SUSPEND_CONVERSION : SuspendConversionStrategy.NO_CONVERSION;
        return new CallableReferenceAdaptation(mappedArgumentTypes, coercion, defaults, adaptedArguments, suspendConversionStrategy);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FakeKotlinCallArgumentForCallableReference> createFakeArgumentsForReference(FunctionDescriptor descriptor2, int expectedArgumentCount, InputOutputTypes inputOutputTypes, int unboundReceiverCount) {
        void $this$mapTo$iv$iv;
        boolean afterVararg = false;
        UnwrappedType varargComponentType = null;
        boolean vararg = false;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)expectedArgumentCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor valueParameterDescriptor;
            void index2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UnwrappedType inputType = (UnwrappedType)CollectionsKt.getOrNull(inputOutputTypes.getInputTypes(), (int)(index2 + unboundReceiverCount));
            if (vararg && !Intrinsics.areEqual(varargComponentType, (Object)inputType)) {
                afterVararg = true;
            }
            List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
            ValueParameterDescriptor valueParameter2 = (ValueParameterDescriptor)CollectionsKt.getOrNull(list2, (int)index2);
            Name name = afterVararg && ((valueParameterDescriptor = valueParameter2) == null ? false : valueParameterDescriptor.declaresDefaultValue()) ? valueParameter2.getName() : null;
            valueParameterDescriptor = valueParameter2;
            if (valueParameterDescriptor == null ? false : ArgumentsUtilsKt.isVararg(valueParameterDescriptor)) {
                varargComponentType = inputType;
                vararg = true;
            }
            FakeKotlinCallArgumentForCallableReference fakeKotlinCallArgumentForCallableReference = new FakeKotlinCallArgumentForCallableReference((int)index2, name);
            collection.add(fakeKotlinCallArgumentForCallableReference);
        }
        return (List)destination$iv$iv;
    }

    private final Pair<KotlinType, VarargMappingState> varargParameterTypeByExpectedParameter(KotlinType expectedParameterType, ValueParameterDescriptor substitutedParameter, VarargMappingState varargMappingState, KotlinBuiltIns builtins) {
        Pair pair;
        Object object = substitutedParameter.getVarargElementType();
        if (object == null) {
            throw new IllegalStateException(("Vararg parameter " + substitutedParameter + " does not have vararg type").toString());
        }
        KotlinType elementType = object;
        object = varargMappingState;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 3: {
                if (KotlinBuiltIns.isArrayOrPrimitiveArray(expectedParameterType) || this.csBuilder.isTypeVariable(expectedParameterType)) {
                    SimpleType simpleType2 = builtins.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType);
                    SimpleType simpleType3 = simpleType2 == null ? builtins.getArrayType(Variance.OUT_VARIANCE, elementType) : simpleType2;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"builtins.getPrimitiveArr\u2026UT_VARIANCE, elementType)");
                    SimpleType arrayType = simpleType3;
                    pair = TuplesKt.to((Object)arrayType, (Object)((Object)VarargMappingState.MAPPED_WITH_ARRAY));
                    break;
                }
                pair = TuplesKt.to((Object)elementType, (Object)((Object)VarargMappingState.MAPPED_WITH_PLAIN_ARGS));
                break;
            }
            case 2: {
                if (KotlinBuiltIns.isArrayOrPrimitiveArray(expectedParameterType)) {
                    pair = TuplesKt.to(null, (Object)((Object)VarargMappingState.MAPPED_WITH_PLAIN_ARGS));
                    break;
                }
                pair = TuplesKt.to((Object)elementType, (Object)((Object)VarargMappingState.MAPPED_WITH_PLAIN_ARGS));
                break;
            }
            case 1: {
                pair = TuplesKt.to(null, (Object)((Object)VarargMappingState.MAPPED_WITH_ARRAY));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Pair<UnwrappedType, CallableReferenceAdaptation> buildReflectionType(CallableDescriptor descriptor, CallableReceiver dispatchReceiver, CallableReceiver extensionReceiver, UnwrappedType expectedType, KotlinBuiltIns builtins) {
        block13: {
            block12: {
                argumentsAndReceivers = new ArrayList<UnwrappedType>(descriptor.getValueParameters().size() + 2);
                if (dispatchReceiver instanceof CallableReceiver.UnboundReference) {
                    argumentsAndReceivers.add(ArgumentsUtilsKt.getStableType(((CallableReceiver.UnboundReference)dispatchReceiver).getReceiver()));
                }
                if (extensionReceiver instanceof CallableReceiver.UnboundReference) {
                    argumentsAndReceivers.add(ArgumentsUtilsKt.getStableType(((CallableReceiver.UnboundReference)extensionReceiver).getReceiver()));
                }
                var8_10 /* !! */  = (var9_7 = descriptor.getReturnType()) == null ? (KotlinType)ErrorUtils.createErrorType(Intrinsics.stringPlus((String)"Error return type for descriptor: ", (Object)descriptor)) : var9_7;
                Intrinsics.checkNotNullExpressionValue((Object)var8_10 /* !! */ , (String)"descriptor.returnType\n  \u2026descriptor: $descriptor\")");
                descriptorReturnType = var8_10 /* !! */ ;
                var8_10 /* !! */  = descriptor;
                if (!(var8_10 /* !! */  instanceof PropertyDescriptor)) break block12;
                if (!((PropertyDescriptor)descriptor).isVar()) ** GOTO lbl-1000
                $this$buildReflectionType_u24lambda_u2d7 = var10_12 = this;
                $i$a$-run-CallableReferencesCandidateFactory$buildReflectionType$mutable$1 = false;
                setter = ((PropertyDescriptor)descriptor).getSetter();
                if (setter == null || DescriptorVisibilities.isVisible((var14_26 = dispatchReceiver) == null ? null : CallableReferenceResolutionKt.access$getAsReceiverValueForVisibilityChecks(var14_26), setter, $this$buildReflectionType_u24lambda_u2d7.getScopeTower().getLexicalScope().getOwnerDescriptor()) != false) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                mutable = v0;
                v1 = TuplesKt.to((Object)this.callComponents.getReflectionTypes().getKPropertyType(Annotations.Companion.getEMPTY(), (List<? extends KotlinType>)argumentsAndReceivers, descriptorReturnType, mutable), null);
                break block13;
            }
            if (var8_10 /* !! */  instanceof FunctionDescriptor) {
                callableReferenceAdaptation = this.getCallableReferenceAdaptation((FunctionDescriptor)descriptor, expectedType, argumentsAndReceivers.size(), builtins);
                if (callableReferenceAdaptation == null) {
                    $this$buildReflectionType_u24lambda_u2d7 = ((FunctionDescriptor)descriptor).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue($this$buildReflectionType_u24lambda_u2d7, (String)"descriptor.valueParameters");
                    $this$mapTo$iv = $this$buildReflectionType_u24lambda_u2d7;
                    $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        var15_28 = (ValueParameterDescriptor)item$iv;
                        var17_30 = argumentsAndReceivers;
                        $i$a$-mapTo-CallableReferencesCandidateFactory$buildReflectionType$returnType$1 = false;
                        var18_31 = it.getType();
                        var17_30.add(var18_31);
                    }
                    (Collection)argumentsAndReceivers;
                    v2 = descriptorReturnType;
                } else {
                    arguments = callableReferenceAdaptation.getArgumentTypes();
                    coercion = callableReferenceAdaptation.getCoercionStrategy();
                    CollectionsKt.addAll((Collection)argumentsAndReceivers, (Object[])arguments);
                    if (coercion == CoercionStrategy.COERCION_TO_UNIT) {
                        var13_25 = DescriptorUtilsKt.getBuiltIns(descriptor).getUnitType();
                        Intrinsics.checkNotNullExpressionValue((Object)var13_25, (String)"descriptor.builtIns.unitType");
                        v2 = var13_25;
                    } else {
                        v2 = descriptorReturnType;
                    }
                }
                returnType = v2;
                coercion = callableReferenceAdaptation;
                suspendConversionStrategy = coercion == null ? null : coercion.getSuspendConversionStrategy();
                isSuspend = ((FunctionDescriptor)descriptor).isSuspend() != false || suspendConversionStrategy == SuspendConversionStrategy.SUSPEND_CONVERSION;
                v1 = TuplesKt.to((Object)this.callComponents.getReflectionTypes().getKFunctionType(Annotations.Companion.getEMPTY(), null, (List<? extends KotlinType>)argumentsAndReceivers, null, returnType, DescriptorUtilsKt.getBuiltIns(descriptor), isSuspend), (Object)callableReferenceAdaptation);
            } else {
                v3 = var9_9 = DescriptorUtilKt.isSupportedForCallableReference(descriptor) == false;
                if (_Assertions.ENABLED && !var9_9) {
                    $i$a$-assert-CallableReferencesCandidateFactory$buildReflectionType$1 = false;
                    var10_15 = Reflection.getOrCreateKotlinClass(descriptor.getClass()) + " isn't supported to use in callable references actually, but it's listed in `isSupportedForCallableReference` method";
                    throw new AssertionError((Object)var10_15);
                }
                v1 = TuplesKt.to((Object)ErrorUtils.createErrorType(Intrinsics.stringPlus((String)"Unsupported descriptor type: ", (Object)descriptor)), null);
            }
        }
        return v1;
    }

    private final CallableReceiver toCallableReceiver(ReceiverValueWithSmartCastInfo receiver, boolean isExplicit) {
        CallableReceiver callableReceiver;
        if (!isExplicit) {
            return new CallableReceiver.ScopeReceiver(receiver);
        }
        LHSResult lhsResult = this.argument.getLhsResult();
        if (lhsResult instanceof LHSResult.Expression) {
            callableReceiver = new CallableReceiver.ExplicitValueReceiver(receiver);
        } else if (lhsResult instanceof LHSResult.Type) {
            ReceiverValue receiverValue;
            QualifierReceiver qualifierReceiver = ((LHSResult.Type)lhsResult).getQualifier();
            callableReceiver = Intrinsics.areEqual(qualifierReceiver == null ? null : ((receiverValue = qualifierReceiver.getClassValueReceiver()) == null ? null : receiverValue.getType()), (Object)receiver.getReceiverValue().getType()) ? (CallableReceiver)new CallableReceiver.BoundValueReference(receiver) : (CallableReceiver)new CallableReceiver.UnboundReference(receiver);
        } else if (lhsResult instanceof LHSResult.Object) {
            callableReceiver = new CallableReceiver.BoundValueReference(receiver);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unsupported kind of lhsResult: ", (Object)lhsResult));
        }
        return callableReceiver;
    }

    private static final CallableReferenceCandidate createCandidate$createReferenceCandidate(CallableDescriptor candidateDescriptor, CallableReceiver dispatchCallableReceiver, CallableReceiver extensionCallableReceiver, ExplicitReceiverKind $explicitReceiverKind, UnwrappedType reflectionCandidateType, CallableReferenceAdaptation callableReferenceAdaptation, SmartList<KotlinCallDiagnostic> diagnostics2) {
        return new CallableReferenceCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, $explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, (List<? extends KotlinCallDiagnostic>)diagnostics2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferencesCandidateFactory$VarargMappingState;", "", "(Ljava/lang/String;I)V", "UNMAPPED", "MAPPED_WITH_PLAIN_ARGS", "MAPPED_WITH_ARRAY", "resolution"})
    private static final class VarargMappingState
    extends Enum<VarargMappingState> {
        public static final /* enum */ VarargMappingState UNMAPPED = new VarargMappingState();
        public static final /* enum */ VarargMappingState MAPPED_WITH_PLAIN_ARGS = new VarargMappingState();
        public static final /* enum */ VarargMappingState MAPPED_WITH_ARRAY = new VarargMappingState();
        private static final /* synthetic */ VarargMappingState[] $VALUES;

        public static VarargMappingState[] values() {
            return (VarargMappingState[])$VALUES.clone();
        }

        public static VarargMappingState valueOf(String value2) {
            return Enum.valueOf(VarargMappingState.class, value2);
        }

        static {
            $VALUES = varargMappingStateArray = new VarargMappingState[]{VarargMappingState.UNMAPPED, VarargMappingState.MAPPED_WITH_PLAIN_ARGS, VarargMappingState.MAPPED_WITH_ARRAY};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VarargMappingState.values().length];
            nArray[VarargMappingState.MAPPED_WITH_ARRAY.ordinal()] = 1;
            nArray[VarargMappingState.MAPPED_WITH_PLAIN_ARGS.ordinal()] = 2;
            nArray[VarargMappingState.UNMAPPED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

