/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallableKt;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/BinaryOp;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "opcode", "", "(I)V", "shift", "", "toCallable", "Lorg/jetbrains/kotlin/codegen/Callable;", "method", "Lorg/jetbrains/kotlin/codegen/CallableMethod;", "backend"})
public final class BinaryOp
extends IntrinsicMethod {
    private final int opcode;

    public BinaryOp(int opcode) {
        this.opcode = opcode;
    }

    private final boolean shift() {
        return this.opcode == 120 || this.opcode == 122 || this.opcode == 124;
    }

    @Override
    @NotNull
    protected Callable toCallable(@NotNull CallableMethod method) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Type returnType2 = method.getReturnType();
        boolean bl2 = bl = method.getValueParameters().size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Type arg0Type = null;
        Type arg1Type = null;
        Type intermediateResultType = null;
        if (!Intrinsics.areEqual((Object)method.getOwner(), (Object)Type.CHAR_TYPE)) {
            Type type2;
            Type type3 = AsmUtil.numberFunctionOperandType(returnType2);
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"numberFunctionOperandType(returnType)");
            arg0Type = intermediateResultType = type3;
            if (this.shift()) {
                type3 = Type.INT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"INT_TYPE");
                type2 = type3;
            } else {
                type2 = arg0Type;
            }
            arg1Type = type2;
        } else {
            Type type4 = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"CHAR_TYPE");
            arg0Type = type4;
            type4 = method.getValueParameters().get(0).getAsmType();
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"method.getValueParameters()[0].asmType");
            arg1Type = type4;
            type4 = AsmUtil.numberFunctionOperandType(returnType2);
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"numberFunctionOperandType(returnType)");
            intermediateResultType = type4;
        }
        return IntrinsicCallableKt.createBinaryIntrinsicCallable$default(returnType2, arg1Type, arg0Type, null, (Function2)new Function2<IntrinsicCallable, InstructionAdapter, Unit>(returnType2, this, intermediateResultType){
            final /* synthetic */ Type $returnType;
            final /* synthetic */ BinaryOp this$0;
            final /* synthetic */ Type $intermediateResultType;
            {
                this.$returnType = $returnType;
                this.this$0 = $receiver;
                this.$intermediateResultType = $intermediateResultType;
                super(2);
            }

            public final void invoke(@NotNull IntrinsicCallable $this$createBinaryIntrinsicCallable, @NotNull InstructionAdapter v) {
                Intrinsics.checkNotNullParameter((Object)$this$createBinaryIntrinsicCallable, (String)"$this$createBinaryIntrinsicCallable");
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                v.visitInsn(this.$returnType.getOpcode(BinaryOp.access$getOpcode$p(this.this$0)));
                StackValue.coerce(this.$intermediateResultType, this.$returnType, v);
            }
        }, 8, null);
    }

    public static final /* synthetic */ int access$getOpcode$p(BinaryOp $this) {
        return $this.opcode;
    }
}

