/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImplKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FunctionPlaceholders;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ArgumentTypeResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final FunctionPlaceholders functionPlaceholders;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final KotlinTypeChecker kotlinTypeChecker;
    private ExpressionTypingServices expressionTypingServices;
    private DoubleColonExpressionResolver doubleColonExpressionResolver;

    public ArgumentTypeResolver(@NotNull TypeResolver typeResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ReflectionTypes reflectionTypes, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull FunctionPlaceholders functionPlaceholders, @NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinTypeChecker kotlinTypeChecker) {
        if (typeResolver == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(1);
        }
        if (reflectionTypes == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(2);
        }
        if (constantExpressionEvaluator == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(3);
        }
        if (functionPlaceholders == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(4);
        }
        if (moduleDescriptor == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(5);
        }
        if (kotlinTypeChecker == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(6);
        }
        this.typeResolver = typeResolver;
        this.builtIns = builtIns;
        this.reflectionTypes = reflectionTypes;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.functionPlaceholders = functionPlaceholders;
        this.moduleDescriptor = moduleDescriptor;
        this.kotlinTypeChecker = kotlinTypeChecker;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(7);
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setDoubleColonExpressionResolver(@NotNull DoubleColonExpressionResolver doubleColonExpressionResolver) {
        if (doubleColonExpressionResolver == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(8);
        }
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
    }

    public boolean isSubtypeOfForArgumentType(@NotNull KotlinType actualType, @NotNull KotlinType expectedType) {
        if (actualType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(9);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(10);
        }
        if (FunctionPlaceholdersKt.isFunctionPlaceholder(actualType)) {
            KotlinType functionType = ConstraintSystemBuilderImplKt.createTypeForFunctionPlaceholder(actualType, expectedType);
            return this.kotlinTypeChecker.isSubtypeOf(functionType, expectedType);
        }
        return this.kotlinTypeChecker.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(11);
        }
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof KtLambdaExpression) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression);
        }
        this.checkTypesForFunctionArgumentsWithNoCallee(context2);
        for (KtTypeProjection ktTypeProjection : context2.call.getTypeArguments()) {
            KtTypeReference typeReference = ktTypeProjection.getTypeReference();
            if (typeReference == null) {
                context2.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(ktTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
        }
    }

    private void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(12);
        }
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context2)) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context2, KtExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        this.updateResultArgumentTypeIfNotDenotable(context2, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(14);
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2) != null;
    }

    public static boolean isCallableReferenceArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(16);
        }
        return ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2) != null;
    }

    public static boolean isFunctionLiteralOrCallableReference(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(18);
        }
        return ArgumentTypeResolver.isFunctionLiteralArgument(expression2, context2) || ArgumentTypeResolver.isCallableReferenceArgument(expression2, context2);
    }

    @Nullable
    public static KtFunction getFunctionLiteralArgumentIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        KtExpression deparenthesizedExpression;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(20);
        }
        if ((deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context2.statementFilter)) instanceof KtLambdaExpression) {
            return ((KtLambdaExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof KtFunction) {
            return (KtFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static KtCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        KtExpression deparenthesizedExpression;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(22);
        }
        if ((deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context2.statementFilter)) instanceof KtCallableReferenceExpression) {
            return (KtCallableReferenceExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public KotlinTypeInfo getArgumentTypeInfo(@Nullable KtExpression expression2, @NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode, boolean suspendFunctionTypeExpected) {
        KotlinTypeInfo recordedTypeInfo;
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(23);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(24);
        }
        if (expression2 == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(25);
            }
            return kotlinTypeInfo;
        }
        KtFunction functionLiteralArgument = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2);
        if (functionLiteralArgument != null) {
            KotlinTypeInfo kotlinTypeInfo = this.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context2, resolveArgumentsMode, suspendFunctionTypeExpected);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(26);
            }
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression callableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2);
        if (callableReferenceExpression != null) {
            KotlinTypeInfo kotlinTypeInfo = this.getCallableReferenceTypeInfo(expression2, callableReferenceExpression, context2, resolveArgumentsMode);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(27);
            }
            return kotlinTypeInfo;
        }
        if (ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context2)) {
            Object newContext = context2.replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(28);
            }
            return kotlinTypeInfo;
        }
        if (UnsignedTypes.INSTANCE.isUnsignedType(context2.expectedType)) {
            this.convertSignedConstantToUnsigned(expression2, context2);
        }
        if ((recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context2.trace.getBindingContext())) != null) {
            KotlinTypeInfo kotlinTypeInfo = recordedTypeInfo;
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(29);
            }
            return kotlinTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(30);
        }
        return kotlinTypeInfo;
    }

    private void convertSignedConstantToUnsigned(@NotNull KtExpression expression2, @NotNull CallResolutionContext<?> context2) {
        CompileTimeConstant<?> constant;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(31);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(32);
        }
        if (!((constant = context2.trace.get(BindingContext.COMPILE_TIME_VALUE, expression2)) instanceof IntegerValueTypeConstant) || !ArgumentTypeResolver.constantCanBeConvertedToUnsigned(constant)) {
            return;
        }
        IntegerValueTypeConstant unsignedConstant = IntegerValueTypeConstant.convertToUnsignedConstant((IntegerValueTypeConstant)constant, this.moduleDescriptor);
        context2.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, unsignedConstant);
        this.updateResultArgumentTypeIfNotDenotable(context2.trace, context2.statementFilter, context2.expectedType, unsignedConstant.getUnknownIntegerType(), expression2);
    }

    public static boolean constantCanBeConvertedToUnsigned(@NotNull CompileTimeConstant<?> constant) {
        if (constant == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(33);
        }
        return !constant.isError() && constant.getParameters().isPure();
    }

    @NotNull
    public KotlinTypeInfo getCallableReferenceTypeInfo(@NotNull KtExpression expression2, @NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(34);
        }
        if (callableReferenceExpression == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(35);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(36);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(37);
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfCallableReference(callableReferenceExpression, context2, true);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(38);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(39);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getShapeTypeOfCallableReference(@NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context2, boolean expectedTypeIsUnknown) {
        if (callableReferenceExpression == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(40);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(41);
        }
        Pair<DoubleColonLHS, OverloadResolutionResults<?>> pair = this.doubleColonExpressionResolver.resolveCallableReference(callableReferenceExpression, ExpressionTypingContext.newContext(context2), ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        DoubleColonLHS lhs = (DoubleColonLHS)pair.getFirst();
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)pair.getSecond();
        if (overloadResolutionResults == null) {
            return null;
        }
        if (ArgumentTypeResolver.isSingleAndPossibleTransformToSuccess(overloadResolutionResults)) {
            ResolvedCall resolvedCall2 = OverloadResolutionResultsUtil.getResultingCall(overloadResolutionResults, context2);
            if (resolvedCall2 == null) {
                return null;
            }
            return DoubleColonExpressionResolver.Companion.createKCallableTypeForReference((CallableDescriptor)resolvedCall2.getResultingDescriptor(), lhs, this.reflectionTypes, context2.scope.getOwnerDescriptor());
        }
        if (expectedTypeIsUnknown) {
            return this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false);
        }
        return FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
    }

    private static boolean isSingleAndPossibleTransformToSuccess(@NotNull OverloadResolutionResults<?> overloadResolutionResults) {
        if (overloadResolutionResults == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(42);
        }
        if (!overloadResolutionResults.isSingleResult()) {
            return false;
        }
        ResolvedCall call2 = (ResolvedCall)CollectionsKt.singleOrNull(overloadResolutionResults.getResultingCalls());
        return call2 != null && call2.getStatus().possibleTransformToSuccess();
    }

    @NotNull
    public KotlinTypeInfo getFunctionLiteralTypeInfo(@NotNull KtExpression expression2, @NotNull KtFunction functionLiteral, @NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode, boolean suspendFunctionTypeExpected) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(43);
        }
        if (functionLiteral == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(44);
        }
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(45);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(46);
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context2.scope, context2.trace, true, suspendFunctionTypeExpected);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, context2);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(47);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(48);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getShapeTypeOfFunctionLiteral(@NotNull KtFunction function2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown, boolean suspendFunctionTypeExpected) {
        if (function2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(49);
        }
        if (scope2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(50);
        }
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(51);
        }
        boolean isFunctionLiteral = function2 instanceof KtFunctionLiteral;
        if (function2.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
        }
        List<KtParameter> valueParameters2 = function2.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        for (KtParameter parameter : valueParameters2) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE));
            Name name = parameter.getNameAsName();
            if (name == null) {
                name = SpecialNames.NO_NAME_PROVIDED;
            }
            parameterNames.add(name);
        }
        KotlinType returnType2 = this.resolveTypeRefWithDefault(function2.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        KotlinType receiverType = this.resolveTypeRefWithDefault(function2.getReceiverTypeReference(), scope2, temporaryTrace, null);
        return expectedTypeIsUnknown && isFunctionLiteral ? this.functionPlaceholders.createFunctionPlaceholderType(parameterTypes, true) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), receiverType, parameterTypes, parameterNames, returnType2, suspendFunctionTypeExpected);
    }

    @Nullable
    public KotlinType resolveTypeRefWithDefault(@Nullable KtTypeReference returnTypeRef, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, @Nullable KotlinType defaultValue2) {
        if (scope2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(52);
        }
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(53);
        }
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope2, returnTypeRef, trace, true);
        }
        return defaultValue2;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(54);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(55);
        }
        MutableDataFlowInfoForArguments infoForArguments = context2.dataFlowInfoForArguments;
        Call call2 = context2.call;
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 == null || ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context2)) continue;
            CallResolutionContext newContext = (CallResolutionContext)context2.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, newContext, resolveArgumentsMode, false);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context2, @NotNull KtExpression expression2) {
        if (context2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(56);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(57);
        }
        return this.updateResultArgumentTypeIfNotDenotable(context2.trace, context2.statementFilter, context2.expectedType, expression2);
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KtExpression expression2) {
        KotlinType type2;
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(58);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(59);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(60);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(61);
        }
        return (type2 = trace.getType(expression2)) != null ? this.updateResultArgumentTypeIfNotDenotable(trace, statementFilter, expectedType, type2, expression2) : null;
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KotlinType targetType, @NotNull KtExpression expression2) {
        TypeConstructor typeConstructor2;
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(62);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(63);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(64);
        }
        if (targetType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(65);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(66);
        }
        if (!(typeConstructor2 = targetType.getConstructor()).isDenotable()) {
            if (typeConstructor2 instanceof IntegerValueTypeConstructor) {
                IntegerValueTypeConstructor constructor = (IntegerValueTypeConstructor)typeConstructor2;
                KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor, expectedType);
                this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, statementFilter, trace);
                return primitiveType;
            }
            if (typeConstructor2 instanceof IntegerLiteralTypeConstructor) {
                IntegerLiteralTypeConstructor constructor = (IntegerLiteralTypeConstructor)typeConstructor2;
                KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor, expectedType);
                this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, statementFilter, trace);
                return primitiveType;
            }
        }
        return null;
    }

    private static boolean isCollectionLiteralInsideAnnotation(KtExpression expression2, CallResolutionContext<?> context2) {
        return expression2 instanceof KtCollectionLiteralExpression && context2.call.getCallElement() instanceof KtAnnotationEntry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reflectionTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionPlaceholders";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypeChecker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleColonExpressionResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 10: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 32: 
            case 36: 
            case 41: 
            case 45: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 31: 
            case 34: 
            case 43: 
            case 57: 
            case 61: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 24: 
            case 37: 
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveArgumentsMode";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableReferenceExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadResolutionResults";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLiteral";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 51: 
            case 53: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypeInfo";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableReferenceTypeInfo";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionLiteralTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionTypingServices";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDoubleColonExpressionResolver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeOfForArgumentType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesWithNoCallee";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesForFunctionArgumentsWithNoCallee";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionLiteralArgument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCallableReferenceArgument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionLiteralOrCallableReference";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralArgumentIfAny";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCallableReferenceExpressionIfAny";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypeInfo";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertSignedConstantToUnsigned";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "constantCanBeConvertedToUnsigned";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCallableReferenceTypeInfo";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getShapeTypeOfCallableReference";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSingleAndPossibleTransformToSuccess";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralTypeInfo";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getShapeTypeOfFunctionLiteral";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeRefWithDefault";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "analyzeArgumentsAndRecordTypes";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "updateResultArgumentTypeIfNotDenotable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

