/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\b\u0010\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u001f\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0002H\u0086\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ClassOneToManyMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "add", "", "key", "Lorg/jetbrains/kotlin/name/FqName;", "value", "dumpValue", "get", "remove", "removeValues", "removed", "", "set", "values", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nClassOneToManyMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassOneToManyMap.kt\norg/jetbrains/kotlin/incremental/storage/ClassOneToManyMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n1549#2:77\n1620#2,3:78\n766#2:81\n857#2,2:82\n*S KotlinDebug\n*F\n+ 1 ClassOneToManyMap.kt\norg/jetbrains/kotlin/incremental/storage/ClassOneToManyMap\n*L\n37#1:73\n37#1:74,3\n46#1:77\n46#1:78,3\n58#1:81\n58#1:82,2\n*E\n"})
public class ClassOneToManyMap
extends BasicStringMap<Collection<? extends String>> {
    public ClassOneToManyMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, StringCollectionExternalizer.INSTANCE, icContext);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }

    public final synchronized void add(@NotNull FqName key, @NotNull FqName value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LazyStorage<String, List> lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.asString()");
        lazyStorage.append(string, CollectionsKt.listOf((Object)value.asString()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Collection<FqName> get(@NotNull FqName key) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.asString()");
        Collection collection2 = (Collection)lazyStorage.get(string);
        if (collection2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(new FqName((String)p0));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void set(@NotNull FqName key, @NotNull Collection<FqName> values) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.isEmpty()) {
            this.remove(key);
            return;
        }
        LazyStorage<String, List> lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.asString()");
        Iterable iterable = values;
        String string2 = string;
        LazyStorage<String, List> lazyStorage2 = lazyStorage;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            FqName fqName = (FqName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asString());
        }
        collection = (List)destination$iv$iv;
        lazyStorage2.set(string2, (List)collection);
    }

    public final synchronized void remove(@NotNull FqName key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.asString()");
        lazyStorage.remove(string);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void removeValues(@NotNull FqName key, @NotNull Set<FqName> removed) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        Iterable $this$filter$iv = this.get(key);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!(!removed.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notRemoved = (List)destination$iv$iv;
        this.set(key, notRemoved);
    }
}

