/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.jexl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.jeasy.rules.api.Action;
import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.core.BasicRule;
import org.jeasy.rules.jexl.JexlAction;
import org.jeasy.rules.jexl.JexlCondition;

public class JexlRule
extends BasicRule {
    static final JexlEngine DEFAULT_JEXL = new JexlBuilder().create();
    private Condition condition = Condition.FALSE;
    private final List<Action> actions = new ArrayList<Action>();
    private final JexlEngine jexl;

    public JexlRule() {
        this(DEFAULT_JEXL);
    }

    public JexlRule(JexlEngine jexl) {
        super("rule", "description", 0x7FFFFFFE);
        this.jexl = Objects.requireNonNull(jexl, "jexl cannot be null");
    }

    public JexlRule name(String name) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        return this;
    }

    public JexlRule description(String description) {
        this.description = Objects.requireNonNull(description, "description cannot be null");
        return this;
    }

    public JexlRule priority(int priority) {
        this.priority = priority;
        return this;
    }

    public JexlRule when(String condition) {
        Objects.requireNonNull(condition, "condition cannot be null");
        this.condition = new JexlCondition(condition, this.jexl);
        return this;
    }

    public JexlRule then(String action) {
        Objects.requireNonNull(action, "action cannot be null");
        this.actions.add(new JexlAction(action, this.jexl));
        return this;
    }

    public boolean evaluate(Facts facts) {
        Objects.requireNonNull(facts, "facts cannot be null");
        return this.condition.evaluate(facts);
    }

    public void execute(Facts facts) throws Exception {
        Objects.requireNonNull(facts, "facts cannot be null");
        for (Action action : this.actions) {
            action.execute(facts);
        }
    }
}

