/*
 * The MIT License
 *
 *   Copyright (c) 2020, Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 *
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *   of this software and associated documentation files (the "Software"), to deal
 *   in the Software without restriction, including without limitation the rights
 *   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *   copies of the Software, and to permit persons to whom the Software is
 *   furnished to do so, subject to the following conditions:
 *
 *   The above copyright notice and this permission notice shall be included in
 *   all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *   THE SOFTWARE.
 */
package org.jeasy.random.randomizers.number;

import org.jeasy.random.api.Randomizer;

import java.util.concurrent.atomic.AtomicLong;

/**
 * Generate a random {@link AtomicLong}.
 *
 * @author Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 */
public class AtomicLongRandomizer implements Randomizer<AtomicLong> {

    private final LongRandomizer delegate;

    /**
     * Create a new {@link AtomicLongRandomizer}.
     */
    public AtomicLongRandomizer() {
        delegate = new LongRandomizer();
    }

    /**
     * Create a new {@link AtomicLongRandomizer}.
     *
     * @param seed initial seed
     */
    public AtomicLongRandomizer(final long seed) {
        delegate = new LongRandomizer(seed);
    }

    /**
     * Create a new {@link AtomicLongRandomizer}.
     *
     * @return a new {@link AtomicLongRandomizer}.
     * @deprecated in favor of the equivalent constructor
     */
    @Deprecated
    public static AtomicLongRandomizer aNewAtomicLongRandomizer() {
        return new AtomicLongRandomizer();
    }

    /**
     * Create a new {@link AtomicLongRandomizer}.
     *
     * @param seed initial seed
     * @return a new {@link AtomicLongRandomizer}.
     * @deprecated in favor of the equivalent constructor
     */
    @Deprecated
    public static AtomicLongRandomizer aNewAtomicLongRandomizer(final long seed) {
        return new AtomicLongRandomizer(seed);
    }

    @Override
    public AtomicLong getRandomValue() {
        return new AtomicLong(delegate.getRandomValue());
    }
}
