/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.writer;

import java.util.concurrent.Callable;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.retry.RetryPolicy;
import org.jeasy.batch.core.retry.RetryTemplate;
import org.jeasy.batch.core.writer.RecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableRecordWriter<P>
implements RecordWriter<P> {
    private RecordWriter<P> delegate;
    private RecordWritingTemplate recordWritingTemplate;

    public RetryableRecordWriter(RecordWriter<P> delegate, RetryPolicy retryPolicy) {
        this.delegate = delegate;
        this.recordWritingTemplate = new RecordWritingTemplate(retryPolicy);
    }

    @Override
    public void open() throws Exception {
        this.delegate.open();
    }

    @Override
    public void writeRecords(Batch<P> batch) throws Exception {
        this.recordWritingTemplate.execute(new RecordWritingCallable(this.delegate, batch));
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private static class RecordWritingTemplate
    extends RetryTemplate {
        private final Logger LOGGER = LoggerFactory.getLogger((String)RecordWritingTemplate.class.getName());

        RecordWritingTemplate(RetryPolicy retryPolicy) {
            super(retryPolicy);
        }

        @Override
        protected void beforeCall() {
        }

        @Override
        protected void afterCall(Object result) {
        }

        @Override
        protected void onException(Exception e) {
            this.LOGGER.error("Unable to write records", (Throwable)e);
        }

        @Override
        protected void onMaxAttempts(Exception e) {
            this.LOGGER.error("Unable to write records after {} attempt(s)", (Object)this.retryPolicy.getMaxAttempts());
        }

        @Override
        protected void beforeWait() {
            this.LOGGER.debug("Waiting for {} {} before retrying to write records", (Object)this.retryPolicy.getDelay(), (Object)this.retryPolicy.getTimeUnit());
        }

        @Override
        protected void afterWait() {
        }
    }

    private static class RecordWritingCallable
    implements Callable<Void> {
        private RecordWriter recordWriter;
        private Batch batch;

        RecordWritingCallable(RecordWriter recordWriter, Batch batch) {
            this.recordWriter = recordWriter;
            this.batch = batch;
        }

        @Override
        public Void call() throws Exception {
            this.recordWriter.writeRecords(this.batch);
            return null;
        }
    }
}

