/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jeasy.batch.core.converter.TypeConverter;
import org.jeasy.batch.core.record.Record;

public abstract class Utils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String JAVA_IO_TMPDIR = System.getProperty("java.io.tmpdir");
    public static final String NOT_APPLICABLE = "N/A";

    private Utils() {
    }

    public static void checkNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The %s must not be null", argumentName));
        }
    }

    public static void checkArgument(boolean assertion, String message) {
        if (!assertion) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Map<String, Method> getGetters(Class<?> type) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            getters.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod());
        }
        getters.remove("class");
        return getters;
    }

    public static String formatTime(LocalDateTime time) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(time);
    }

    public static String formatDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long seconds = duration.getSeconds();
        long milliseconds = duration.toMillis();
        return (String)(days > 0L ? days + "d " : "") + (String)(hours > 0L ? hours - TimeUnit.DAYS.toHours(days) + "hr " : "") + (String)(minutes > 0L ? minutes - TimeUnit.HOURS.toMinutes(hours) + "min " : "") + (String)(seconds > 0L ? seconds - TimeUnit.MINUTES.toSeconds(minutes) + "sec " : "") + (milliseconds - TimeUnit.SECONDS.toMillis(seconds)) + "ms";
    }

    public static String formatErrorThreshold(long errorThreshold) {
        return errorThreshold == Long.MAX_VALUE ? NOT_APPLICABLE : String.valueOf(errorThreshold);
    }

    public static <P> List<P> extractPayloads(List<? extends Record<P>> records) {
        ArrayList<P> payloads = new ArrayList<P>();
        for (Record<P> record : records) {
            payloads.add(record.getPayload());
        }
        return payloads;
    }

    public static Class<?> getGenericTypeNameFromTypeConverter(TypeConverter<?, ?> typeConverter, int genericTypeIndex) throws Exception {
        Class<?> typeConverterClass = typeConverter.getClass();
        Type[] genericInterfaces = typeConverterClass.getGenericInterfaces();
        Type genericInterface = genericInterfaces[0];
        if (!(genericInterface instanceof ParameterizedType)) {
            throw new Exception("The type converter" + typeConverterClass.getName() + " should be a parametrized type");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
        Type type = parameterizedType.getActualTypeArguments()[genericTypeIndex];
        String className = Utils.getClassName(type);
        return Class.forName(className);
    }

    private static String getClassName(Type actualTypeArgument) {
        return actualTypeArgument.toString().substring(6);
    }
}

