/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.retry;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jeasy.batch.core.retry.RetryPolicy;

public abstract class RetryTemplate {
    protected RetryPolicy retryPolicy;

    public RetryTemplate(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public <T> T execute(Callable<T> callable) throws Exception {
        int attempts = 0;
        int maxAttempts = this.retryPolicy.getMaxAttempts();
        long delay = this.retryPolicy.getDelay();
        TimeUnit timeUnit = this.retryPolicy.getTimeUnit();
        while (attempts < maxAttempts) {
            try {
                ++attempts;
                this.beforeCall();
                T result = callable.call();
                this.afterCall(result);
                return result;
            }
            catch (Exception e) {
                this.onException(e);
                if (attempts >= maxAttempts) {
                    this.onMaxAttempts(e);
                    throw e;
                }
                this.beforeWait();
                Thread.sleep(timeUnit.toMillis(delay));
                this.afterWait();
            }
        }
        return null;
    }

    protected abstract void beforeCall();

    protected abstract void afterCall(Object var1);

    protected abstract void onException(Exception var1);

    protected abstract void onMaxAttempts(Exception var1);

    protected abstract void beforeWait();

    protected abstract void afterWait();
}

