/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.mapper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jeasy.batch.core.converter.AtomicIntegerTypeConverter;
import org.jeasy.batch.core.converter.AtomicLongTypeConverter;
import org.jeasy.batch.core.converter.BigDecimalTypeConverter;
import org.jeasy.batch.core.converter.BigIntegerTypeConverter;
import org.jeasy.batch.core.converter.BooleanTypeConverter;
import org.jeasy.batch.core.converter.ByteTypeConverter;
import org.jeasy.batch.core.converter.CharacterTypeConverter;
import org.jeasy.batch.core.converter.DateTypeConverter;
import org.jeasy.batch.core.converter.DoubleTypeConverter;
import org.jeasy.batch.core.converter.FloatTypeConverter;
import org.jeasy.batch.core.converter.GregorianCalendarTypeConverter;
import org.jeasy.batch.core.converter.IntegerTypeConverter;
import org.jeasy.batch.core.converter.LocalDateConverter;
import org.jeasy.batch.core.converter.LocalDateTimeConverter;
import org.jeasy.batch.core.converter.LocalTimeConverter;
import org.jeasy.batch.core.converter.LongTypeConverter;
import org.jeasy.batch.core.converter.ShortTypeConverter;
import org.jeasy.batch.core.converter.SqlDateTypeConverter;
import org.jeasy.batch.core.converter.SqlTimeTypeConverter;
import org.jeasy.batch.core.converter.SqlTimestampTypeConverter;
import org.jeasy.batch.core.converter.StringTypeConverter;
import org.jeasy.batch.core.converter.TypeConverter;
import org.jeasy.batch.core.mapper.BeanIntrospectionException;
import org.jeasy.batch.core.mapper.TypeConverterRegistrationException;
import org.jeasy.batch.core.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ObjectMapper.class.getName());
    private Class<T> objectType;
    private Map<String, Method> setters;
    private Map<Class<?>, TypeConverter<String, ?>> typeConverters;

    public ObjectMapper(Class<T> objectType) {
        this.objectType = objectType;
        this.initializeTypeConverters();
        this.initializeSetters();
    }

    public T mapObject(Map<String, String> values) throws Exception {
        T result = this.createInstance();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String field = entry.getKey();
            String value = values.get(field);
            Method setter = this.setters.get(field);
            if (setter == null) {
                LOGGER.warn("No public setter found for field {}, this field will be set to null (if object type) or default value (if primitive type)", (Object)field);
                continue;
            }
            Class<?> type = setter.getParameterTypes()[0];
            TypeConverter<String, ?> typeConverter = this.typeConverters.get(type);
            if (typeConverter == null) {
                LOGGER.warn("Type conversion not supported for type {}, field {} will be set to null (if object type) or default value (if primitive type)", type, (Object)field);
                continue;
            }
            if (value == null) {
                LOGGER.warn("Attempting to convert null to type {} for field {}, this field will be set to null (if object type) or default value (if primitive type)", type, (Object)field);
                continue;
            }
            if (value.isEmpty()) {
                LOGGER.debug("Attempting to convert an empty string to type {} for field {}, this field will be ignored", type, (Object)field);
                continue;
            }
            this.convertValue(result, field, value, setter, type, typeConverter);
        }
        return result;
    }

    private void initializeSetters() {
        this.setters = new HashMap<String, Method>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.objectType);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            this.getSetters(propertyDescriptors);
        }
        catch (IntrospectionException e) {
            throw new BeanIntrospectionException("Unable to introspect target type " + this.objectType.getName(), e);
        }
    }

    private void getSetters(PropertyDescriptor[] propertyDescriptors) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.setters.put(propertyDescriptor.getName(), propertyDescriptor.getWriteMethod());
        }
        this.setters.remove("class");
    }

    private T createInstance() throws Exception {
        try {
            return this.objectType.newInstance();
        }
        catch (Exception e) {
            throw new Exception(String.format("Unable to create a new instance of target type %s", this.objectType.getName()), e);
        }
    }

    private void convertValue(Object result, String field, String value, Method setter, Class<?> type, TypeConverter<String, ?> typeConverter) throws Exception {
        try {
            Object typedValue = typeConverter.convert(value);
            setter.invoke(result, typedValue);
        }
        catch (Exception e) {
            throw new Exception(String.format("Unable to convert %s to type %s for field %s", value, type, field), e);
        }
    }

    private void initializeTypeConverters() {
        this.typeConverters = new HashMap();
        this.typeConverters.put(AtomicInteger.class, new AtomicIntegerTypeConverter());
        this.typeConverters.put(AtomicLong.class, new AtomicLongTypeConverter());
        this.typeConverters.put(BigDecimal.class, new BigDecimalTypeConverter());
        this.typeConverters.put(BigInteger.class, new BigIntegerTypeConverter());
        this.typeConverters.put(Boolean.class, new BooleanTypeConverter());
        this.typeConverters.put(Boolean.TYPE, new BooleanTypeConverter());
        this.typeConverters.put(Byte.class, new ByteTypeConverter());
        this.typeConverters.put(Byte.TYPE, new ByteTypeConverter());
        this.typeConverters.put(Character.class, new CharacterTypeConverter());
        this.typeConverters.put(Character.TYPE, new CharacterTypeConverter());
        this.typeConverters.put(Double.class, new DoubleTypeConverter());
        this.typeConverters.put(Double.TYPE, new DoubleTypeConverter());
        this.typeConverters.put(Float.class, new FloatTypeConverter());
        this.typeConverters.put(Float.TYPE, new FloatTypeConverter());
        this.typeConverters.put(Integer.class, new IntegerTypeConverter());
        this.typeConverters.put(Integer.TYPE, new IntegerTypeConverter());
        this.typeConverters.put(Long.class, new LongTypeConverter());
        this.typeConverters.put(Long.TYPE, new LongTypeConverter());
        this.typeConverters.put(Short.class, new ShortTypeConverter());
        this.typeConverters.put(Short.TYPE, new ShortTypeConverter());
        this.typeConverters.put(java.util.Date.class, new DateTypeConverter());
        this.typeConverters.put(Calendar.class, new GregorianCalendarTypeConverter());
        this.typeConverters.put(GregorianCalendar.class, new GregorianCalendarTypeConverter());
        this.typeConverters.put(Date.class, new SqlDateTypeConverter());
        this.typeConverters.put(Time.class, new SqlTimeTypeConverter());
        this.typeConverters.put(Timestamp.class, new SqlTimestampTypeConverter());
        this.typeConverters.put(LocalDate.class, new LocalDateConverter());
        this.typeConverters.put(LocalTime.class, new LocalTimeConverter());
        this.typeConverters.put(LocalDateTime.class, new LocalDateTimeConverter());
        this.typeConverters.put(String.class, new StringTypeConverter());
    }

    public void registerTypeConverter(TypeConverter<String, ?> typeConverter) {
        Class<?> clazz;
        try {
            clazz = Utils.getGenericTypeNameFromTypeConverter(typeConverter, 1);
        }
        catch (Exception e) {
            throw new TypeConverterRegistrationException("Unable to register custom type converter " + typeConverter.getClass().getName(), e);
        }
        this.typeConverters.put(clazz, typeConverter);
    }
}

