/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jeasy.batch.core.listener.BatchListener;
import org.jeasy.batch.core.record.Batch;

public class CompositeBatchListener<P>
implements BatchListener<P> {
    private List<BatchListener<P>> listeners;

    public CompositeBatchListener() {
        this(new ArrayList<BatchListener<P>>());
    }

    public CompositeBatchListener(List<BatchListener<P>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeBatchReading() {
        for (BatchListener<P> listener : this.listeners) {
            listener.beforeBatchReading();
        }
    }

    @Override
    public void afterBatchProcessing(Batch<P> batch) {
        ListIterator<BatchListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().afterBatchProcessing(batch);
        }
    }

    @Override
    public void afterBatchWriting(Batch<P> batch) {
        ListIterator<BatchListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().afterBatchWriting(batch);
        }
    }

    @Override
    public void onBatchWritingException(Batch<P> batch, Throwable throwable) {
        ListIterator<BatchListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().onBatchWritingException(batch, throwable);
        }
    }

    public void addBatchListener(BatchListener<P> batchListener) {
        this.listeners.add(batchListener);
    }
}

