/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jeasy.batch.core.job.Job;
import org.jeasy.batch.core.job.JobReport;
import org.jeasy.batch.core.util.Utils;

public class JobExecutor
implements AutoCloseable {
    private ExecutorService executorService;

    public JobExecutor() {
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public JobExecutor(int nbWorkers) {
        this.executorService = Executors.newFixedThreadPool(nbWorkers);
    }

    public JobExecutor(ExecutorService executorService) {
        Utils.checkNotNull(executorService, "executor service");
        this.executorService = executorService;
    }

    public JobReport execute(Job job) {
        try {
            return this.executorService.submit(job).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to execute job " + job.getName(), e);
        }
    }

    public Future<JobReport> submit(Job job) {
        return this.executorService.submit(job);
    }

    public List<Future<JobReport>> submitAll(Job ... jobs) {
        return this.submitAll(Arrays.asList(jobs));
    }

    public List<Future<JobReport>> submitAll(List<Job> jobs) {
        try {
            return this.executorService.invokeAll(jobs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to execute jobs", e);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void awaitTermination(long timeout, TimeUnit unit) {
        try {
            this.executorService.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Job executor was interrupted while waiting");
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

