/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.keystone;

import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.SwiftKeystoneClient;
import org.jclouds.openstack.swift.internal.BaseSwiftKeystoneExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccessKeyAndSecretKeyAuthenticationExpectTest")
public class AccessKeyAndSecretKeyAuthenticationExpectTest
extends BaseSwiftKeystoneExpectTest<SwiftKeystoneClient> {
    @Override
    protected Properties setupProperties() {
        Properties contextProperties = super.setupProperties();
        contextProperties.setProperty("jclouds.keystone.credential-type", "apiAccessKeyCredentials");
        return contextProperties;
    }

    public void testContainerExistsWhenResponseIs2xx() throws Exception {
        HttpRequest containerExists = ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse containerExistsResponse = HttpResponse.builder().statusCode(200).build();
        SwiftKeystoneClient clientWhenContainerExists = (SwiftKeystoneClient)this.requestsSendResponses(this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantName, this.responseWithKeystoneAccess, containerExists, containerExistsResponse);
        Assert.assertEquals((boolean)clientWhenContainerExists.containerExists("container"), (boolean)true);
    }
}

