/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.internal;

import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.internal.KeystoneFixture;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.rest.internal.BaseRestClientExpectTest;

public class BaseSwiftKeystoneExpectTest<T>
extends BaseRestClientExpectTest<T> {
    protected HttpRequest keystoneAuthWithUsernameAndPassword;
    protected HttpRequest keystoneAuthWithUsernameAndPasswordAndTenantName;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKeyAndTenantName;
    protected String authToken;
    protected HttpResponse responseWithKeystoneAccess;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKeyAndTenantId;
    protected String identityWithTenantId;

    public BaseSwiftKeystoneExpectTest() {
        this.provider = "swift-keystone";
        this.keystoneAuthWithUsernameAndPassword = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPassword(this.identity, this.credential);
        this.keystoneAuthWithUsernameAndPasswordAndTenantName = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPasswordAndTenantName(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantName = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKeyAndTenantName(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantId = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKeyAndTenantId(this.identity, this.credential);
        this.authToken = KeystoneFixture.INSTANCE.getAuthToken();
        this.responseWithKeystoneAccess = KeystoneFixture.INSTANCE.responseWithAccess();
        this.identityWithTenantId = KeystoneFixture.INSTANCE.getTenantId() + ":" + this.identity;
        this.identity = KeystoneFixture.INSTANCE.getTenantName() + ":" + this.identity;
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.regions", "region-a.geo-1,RegionOne");
        return overrides;
    }

    protected HttpRequest.Builder<?> authenticatedGET() {
        return (HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken});
    }

    protected BaseRestApiExpectTest.HttpRequestComparisonType compareHttpRequestAsType(HttpRequest input) {
        return BaseRestApiExpectTest.HttpRequestComparisonType.JSON;
    }
}

