/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.functions;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.domain.AuthenticationResponse;
import org.jclouds.openstack.functions.ParseAuthenticationResponseFromHeaders;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseAuthenticationResponseFromHeadersTest")
public class ParseAuthenticationResponseFromHeadersTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.blobstore.metaprefix")).to("sdf");
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.api-version")).to("1");
            this.bind(UriBuilder.class).to(UriBuilderImpl.class);
        }
    }});

    public void testReplaceLocalhost() {
        ParseAuthenticationResponseFromHeaders parser = (ParseAuthenticationResponseFromHeaders)this.i.getInstance(ParseAuthenticationResponseFromHeaders.class);
        parser = parser.setHostToReplace("fooman");
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(204).message("No Content").addHeader("X-Auth-Token", new String[]{"token"})).addHeader("X-Storage-Token", new String[]{"token"})).addHeader("X-Storage-Url", new String[]{"http://127.0.0.1:8080/v1/token"})).build();
        AuthenticationResponse md = parser.apply(response);
        Assert.assertEquals((Object)md, (Object)new AuthenticationResponse("token", (Map)ImmutableMap.of((Object)"X-Storage-Url", (Object)URI.create("http://fooman:8080/v1/token"))));
    }
}

