/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.InvocationContext;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.util.S3Utils;
import org.jclouds.util.Throwables2;

public class ReturnFalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists
implements Function<Exception, Boolean>,
InvocationContext<ReturnFalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists> {
    private final S3Client client;
    private String bucket;

    @Inject
    ReturnFalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(S3Client client) {
        this.client = client;
    }

    public Boolean apply(Exception from) {
        AWSResponseException exception = (AWSResponseException)Throwables2.getFirstThrowableOfType((Throwable)from, AWSResponseException.class);
        if (exception != null && exception.getError() != null && exception.getError().getCode() != null) {
            String code = exception.getError().getCode();
            if (code.equals("BucketAlreadyOwnedByYou")) {
                return false;
            }
            if (code.equals("OperationAborted") && this.bucket != null && this.client.bucketExists(this.bucket)) {
                return false;
            }
        }
        throw Throwables.propagate((Throwable)from);
    }

    public ReturnFalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists setContext(@Nullable HttpRequest request) {
        if (request != null) {
            this.bucket = S3Utils.getBucketName(request);
        }
        return this;
    }
}

