/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;

@Singleton
public class DefaultEndpointThenInvalidateRegion
implements Function<Object, URI> {
    private final LoadingCache<String, Optional<String>> bucketToRegionCache;
    private final AssignCorrectHostnameForBucket r2;

    @Inject
    public DefaultEndpointThenInvalidateRegion(AssignCorrectHostnameForBucket r2, @Bucket LoadingCache<String, Optional<String>> bucketToRegionCache) {
        this.r2 = r2;
        this.bucketToRegionCache = bucketToRegionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI apply(@Nullable Object from) {
        try {
            URI uRI = this.r2.apply(from);
            return uRI;
        }
        finally {
            this.bucketToRegionCache.invalidate((Object)from.toString());
        }
    }
}

