/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.HumanTaskHandlerHelper;
import org.jbpm.task.AccessType;
import org.jbpm.task.Content;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.SubTasksStrategyFactory;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.OnErrorAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWSHumanTaskHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(SyncWSHumanTaskHandler.class);
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private TaskService client;
    private WorkItemManager manager = null;
    private KnowledgeRuntime session;
    private boolean local = false;
    private OnErrorAction action;
    protected Map<TaskEventKey, EventResponseHandler> eventHandlers = new HashMap<TaskEventKey, EventResponseHandler>();
    private boolean initialized = false;

    public SyncWSHumanTaskHandler() {
        this.action = OnErrorAction.LOG;
    }

    public SyncWSHumanTaskHandler(TaskService client) {
        this.client = client;
        this.action = OnErrorAction.LOG;
    }

    public SyncWSHumanTaskHandler(TaskService client, KnowledgeRuntime session) {
        this.client = client;
        this.session = session;
        this.action = OnErrorAction.LOG;
    }

    public SyncWSHumanTaskHandler(TaskService client, OnErrorAction action) {
        this.client = client;
        this.action = action;
    }

    public SyncWSHumanTaskHandler(TaskService client, KnowledgeRuntime session, OnErrorAction action) {
        this.client = client;
        this.session = session;
        this.action = action;
    }

    public void setConnection(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public void setClient(TaskService client) {
        this.client = client;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    public void setSession(KnowledgeRuntime session) {
        this.session = session;
    }

    public void connect() {
        if (!this.initialized) {
            boolean connected;
            if (this.client == null) {
                throw new IllegalStateException("You must set the client to the work item to work");
            }
            if (this.client != null && !(connected = this.client.connect(this.ipAddress, this.port))) {
                throw new IllegalArgumentException("Could not connect task client");
            }
            this.registerTaskEvents();
            this.initialized = true;
        }
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    private void registerTaskEvents() {
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block29: {
            String groupId;
            String subTaskStrategiesCommaSeparated;
            String comment;
            String taskName;
            if (this.session == null) {
                if (this.manager == null) {
                    this.manager = manager;
                } else if (this.manager != manager) {
                    throw new IllegalArgumentException("This WSHumanTaskHandler can only be used for one WorkItemManager");
                }
            }
            this.connect();
            Task task = new Task();
            String locale = (String)workItem.getParameter("Locale");
            if (locale == null) {
                locale = "en-UK";
            }
            if ((taskName = (String)workItem.getParameter("TaskName")) != null) {
                ArrayList<I18NText> names = new ArrayList<I18NText>();
                names.add(new I18NText(locale, taskName));
                task.setNames(names);
            }
            if ((comment = (String)workItem.getParameter("Comment")) == null) {
                comment = "";
            }
            ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
            descriptions.add(new I18NText(locale, comment));
            task.setDescriptions(descriptions);
            ArrayList<I18NText> subjects = new ArrayList<I18NText>();
            subjects.add(new I18NText(locale, comment));
            task.setSubjects(subjects);
            String priorityString = (String)workItem.getParameter("Priority");
            int priority = 0;
            if (priorityString != null) {
                try {
                    priority = new Integer(priorityString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            task.setPriority(priority);
            TaskData taskData = new TaskData();
            taskData.setWorkItemId(workItem.getId());
            taskData.setProcessInstanceId(workItem.getProcessInstanceId());
            if (this.session != null && this.session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
                taskData.setProcessId(this.session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
            }
            if (this.session != null && this.session instanceof StatefulKnowledgeSession) {
                taskData.setProcessSessionId(((StatefulKnowledgeSession)this.session).getId());
            }
            taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
            Long parentId = (Long)workItem.getParameter("ParentId");
            if (parentId != null) {
                taskData.setParentId(parentId);
            }
            if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
                String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
                ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
                for (String subTaskStrategyString : subTaskStrategies) {
                    SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy(subTaskStrategyString);
                    strategies.add(subTaskStrategy);
                }
                task.setSubTaskStrategies(strategies);
            }
            PeopleAssignments assignments = new PeopleAssignments();
            ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
            String actorId = (String)workItem.getParameter("ActorId");
            if (actorId != null && actorId.trim().length() > 0) {
                String[] actorIds;
                for (String id : actorIds = actorId.split(",")) {
                    potentialOwners.add(new User(id.trim()));
                }
                if (potentialOwners.size() > 0) {
                    taskData.setCreatedBy((User)potentialOwners.get(0));
                }
            }
            if ((groupId = (String)workItem.getParameter("GroupId")) != null && groupId.trim().length() > 0) {
                String[] groupIds;
                for (String id : groupIds = groupId.split(",")) {
                    potentialOwners.add(new Group(id.trim()));
                }
            }
            assignments.setPotentialOwners(potentialOwners);
            ArrayList<OrganizationalEntity> businessAdministrators = new ArrayList<OrganizationalEntity>();
            businessAdministrators.add(new User("Administrator"));
            assignments.setBusinessAdministrators(businessAdministrators);
            task.setPeopleAssignments(assignments);
            task.setTaskData(taskData);
            ContentData content = null;
            Object contentObject = workItem.getParameter("Content");
            if (contentObject == null) {
                contentObject = workItem.getParameters();
            }
            if (contentObject != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream out = new ObjectOutputStream(bos);
                    out.writeObject(contentObject);
                    out.close();
                    content = new ContentData();
                    content.setContent(bos.toByteArray());
                    content.setAccessType(AccessType.Inline);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            task.setDeadlines(HumanTaskHandlerHelper.setDeadlines(workItem, businessAdministrators));
            try {
                this.client.addTask(task, content);
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    this.session.getWorkItemManager().abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block29;
                StringBuffer logMsg = new StringBuffer();
                logMsg.append(new Date() + ": Error when creating task on task server for work item id " + workItem.getId());
                logMsg.append(". Error reported by task server: " + e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
            }
        }
    }

    public void dispose() throws Exception {
        for (TaskEventKey key : this.eventHandlers.keySet()) {
            this.client.unregisterForEvent(key);
        }
        this.eventHandlers.clear();
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Task task = this.client.getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                this.client.exit(task.getId(), "Administrator");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }

    private class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private TaskCompletedHandler() {
        }

        @Override
        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            final long taskId = event.getTaskId();
            if (SyncWSHumanTaskHandler.this.local) {
                this.handleCompletedTask(taskId);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TaskCompletedHandler.this.handleCompletedTask(taskId);
                    }
                };
                new Thread(runnable).start();
            }
        }

        @Override
        public boolean isRemove() {
            return false;
        }

        public void handleCompletedTask(long taskId) {
            block14: {
                Task task = SyncWSHumanTaskHandler.this.client.getTask(taskId);
                long workItemId = task.getTaskData().getWorkItemId();
                if (task.getTaskData().getStatus() == Status.Completed) {
                    String userId = task.getTaskData().getActualOwner().getId();
                    HashMap<String, Object> results = new HashMap<String, Object>();
                    results.put("ActorId", userId);
                    long contentId = task.getTaskData().getOutputContentId();
                    if (contentId != -1L) {
                        Content content = SyncWSHumanTaskHandler.this.client.getContent(contentId);
                        ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
                        try {
                            ObjectInputStream in = new ObjectInputStream(bis);
                            Object result = in.readObject();
                            in.close();
                            results.put("Result", result);
                            if (result instanceof Map) {
                                Map map = (Map)result;
                                for (Map.Entry entry : map.entrySet()) {
                                    if (!(entry.getKey() instanceof String)) continue;
                                    results.put((String)entry.getKey(), entry.getValue());
                                }
                            }
                            if (SyncWSHumanTaskHandler.this.session != null) {
                                SyncWSHumanTaskHandler.this.session.getWorkItemManager().completeWorkItem(task.getTaskData().getWorkItemId(), results);
                                break block14;
                            }
                            SyncWSHumanTaskHandler.this.manager.completeWorkItem(task.getTaskData().getWorkItemId(), results);
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    } else if (SyncWSHumanTaskHandler.this.session != null) {
                        SyncWSHumanTaskHandler.this.session.getWorkItemManager().completeWorkItem(workItemId, results);
                    } else {
                        SyncWSHumanTaskHandler.this.manager.completeWorkItem(workItemId, results);
                    }
                } else if (SyncWSHumanTaskHandler.this.session != null) {
                    SyncWSHumanTaskHandler.this.session.getWorkItemManager().abortWorkItem(workItemId);
                } else {
                    SyncWSHumanTaskHandler.this.manager.abortWorkItem(workItemId);
                }
            }
        }
    }
}

