/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.context;

import org.jbpm.process.core.Context;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.AbstractContextInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.context.WorkflowContextInstance;

public class WorkflowReuseContextInstanceFactory
implements ContextInstanceFactory {
    public final Class<? extends ContextInstance> cls;

    public WorkflowReuseContextInstanceFactory(Class<? extends ContextInstance> cls) {
        this.cls = cls;
    }

    @Override
    public ContextInstance getContextInstance(Context context, ContextInstanceContainer contextInstanceContainer, ProcessInstance processInstance) {
        ContextInstance result = contextInstanceContainer.getContextInstance(context.getType(), context.getId());
        if (result != null) {
            return result;
        }
        try {
            AbstractContextInstance contextInstance = (AbstractContextInstance)this.cls.newInstance();
            contextInstance.setContextId(context.getId());
            contextInstance.setContextInstanceContainer(contextInstanceContainer);
            contextInstance.setProcessInstance(processInstance);
            contextInstanceContainer.addContextInstance(context.getType(), contextInstance);
            NodeInstanceContainer nodeInstanceContainer = null;
            if (contextInstanceContainer instanceof NodeInstanceContainer) {
                nodeInstanceContainer = (NodeInstanceContainer)((Object)contextInstanceContainer);
            } else if (contextInstanceContainer instanceof ContextInstance) {
                ContextInstanceContainer parent = ((ContextInstance)((Object)contextInstanceContainer)).getContextInstanceContainer();
                while (parent != null) {
                    if (parent instanceof NodeInstanceContainer) {
                        nodeInstanceContainer = (NodeInstanceContainer)((Object)parent);
                        continue;
                    }
                    if (contextInstanceContainer instanceof ContextInstance) {
                        parent = ((ContextInstance)((Object)contextInstanceContainer)).getContextInstanceContainer();
                        continue;
                    }
                    parent = null;
                }
            }
            ((WorkflowContextInstance)((Object)contextInstance)).setNodeInstanceContainer(nodeInstanceContainer);
            return contextInstance;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate context '" + this.cls.getName() + "': " + e.getMessage());
        }
    }
}

