/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.EnumDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ListDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;

public class TypeConverter {
    private static final Map<Class<?>, DataType> classTypeMap = new ConcurrentHashMap();

    private TypeConverter() {
    }

    public static DataType fromType(Class<?> type) {
        return classTypeMap.computeIfAbsent(type, TypeConverter::missingDataType);
    }

    private static DataType missingDataType(Class<?> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumDataType(type.getName());
        }
        return new ObjectDataType(type.getName());
    }

    static {
        classTypeMap.put(Boolean.class, new BooleanDataType());
        classTypeMap.put(Integer.class, new IntegerDataType());
        classTypeMap.put(Float.class, new FloatDataType());
        classTypeMap.put(String.class, new StringDataType());
        classTypeMap.put(List.class, new ListDataType());
    }
}

