/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.microcontainer.beans.BasePolicyModule;

public class FlaggedPolicyModule
extends BasePolicyModule {
    protected String flag;
    protected AppConfigurationEntry.LoginModuleControlFlag controlFlag;

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        if (flag == null) {
            throw new IllegalArgumentException("Invalid null module flag");
        }
        flag = flag.toLowerCase();
        if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else {
            throw new IllegalArgumentException("Invalid module flag: " + flag);
        }
        this.flag = flag;
    }

    public AppConfigurationEntry getAppConfigurationEntry() {
        return new AppConfigurationEntry(this.code, this.controlFlag, this.options);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Login module class: " + this.code);
        buffer.append("\nLogin module flag: " + this.flag);
        buffer.append("\nLogin module options: \n");
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            buffer.append("\tname= " + entry.getKey() + ", value= " + entry.getValue() + "\n");
        }
        return buffer.toString();
    }
}

