/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.seam.persistence.QueryParser;

public class HibernateSessionInvocationHandler
implements InvocationHandler,
Serializable {
    private Session delegate;

    public HibernateSessionInvocationHandler(Session delegate) {
        this.delegate = delegate;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if ("createQuery".equals(method.getName()) && method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(String.class)) {
                return this.handleCreateQueryWithString(method, args);
            }
            if ("reconnect".equals(method.getName()) && method.getParameterTypes().length == 0) {
                return this.handleReconnectNoArg(method);
            }
            return method.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected Object handleCreateQueryWithString(Method method, Object[] args) throws Throwable {
        if (args[0] == null) {
            return method.invoke((Object)this.delegate, args);
        }
        String ejbql = (String)args[0];
        if (ejbql.indexOf(35) > 0) {
            QueryParser qp = new QueryParser(ejbql);
            Object[] newArgs = (Object[])args.clone();
            newArgs[0] = qp.getEjbql();
            Query query = (Query)method.invoke((Object)this.delegate, newArgs);
            for (int i = 0; i < qp.getParameterValueBindings().size(); ++i) {
                query.setParameter(QueryParser.getParameterName(i), qp.getParameterValueBindings().get(i).getValue());
            }
            return query;
        }
        return method.invoke((Object)this.delegate, args);
    }

    protected Object handleReconnectNoArg(Method method) throws Throwable {
        throw new UnsupportedOperationException("deprecated");
    }
}

