/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.security.management.IdentityManagementException;
import org.jboss.seam.security.management.IdentityStore;
import org.jboss.seam.security.management.UserAccount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class JpaIdentityStore
extends IdentityStore {
    private Class<? extends UserAccount> accountClass;
    private String entityManagerName = "entityManager";
    private Set<UserAccount> roleCache;

    @Create
    public void init() {
        this.loadRoles();
    }

    protected void loadRoles() {
        List roles = this.getEntityManager().createQuery("from " + this.accountClass.getName() + " where enabled = true and accountType = :accountType").setParameter("accountType", (Object)UserAccount.AccountType.role).getResultList();
        this.roleCache = new HashSet<UserAccount>();
        this.roleCache.addAll(roles);
    }

    @Override
    public boolean createAccount(String username, String password) {
        try {
            if (this.accountClass == null) {
                throw new IdentityManagementException("Could not create account, accountClass not set");
            }
            UserAccount account = this.accountClass.newInstance();
            account.setAccountType(UserAccount.AccountType.user);
            account.setUsername(username);
            if (password == null) {
                account.setEnabled(false);
            } else {
                account.setPasswordHash(this.hashPassword(password));
                account.setEnabled(true);
            }
            this.persistAccount(account);
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof IdentityManagementException) {
                throw (IdentityManagementException)ex;
            }
            throw new IdentityManagementException("Could not create account", ex);
        }
    }

    @Override
    public boolean deleteAccount(String name) {
        UserAccount account = this.validateUser(name);
        this.getEntityManager().remove((Object)account);
        return true;
    }

    @Override
    public boolean grantRole(String name, String role) {
        UserAccount account = this.validateUser(name);
        UserAccount roleToGrant = this.validateRole(role);
        if (account.getMemberships() == null) {
            account.setMemberships(new HashSet<UserAccount>());
        } else if (account.getMemberships().contains(roleToGrant)) {
            return false;
        }
        account.getMemberships().add(roleToGrant);
        this.mergeAccount(account);
        return true;
    }

    @Override
    public boolean revokeRole(String name, String role) {
        UserAccount account = this.validateUser(name);
        UserAccount roleToRevoke = this.validateRole(role);
        boolean success = account.getMemberships().remove(roleToRevoke);
        this.mergeAccount(account);
        return success;
    }

    @Override
    public boolean enableAccount(String name) {
        UserAccount account = this.validateUser(name);
        if (account.isEnabled()) {
            return false;
        }
        account.setEnabled(true);
        this.mergeAccount(account);
        return true;
    }

    @Override
    public boolean disableAccount(String name) {
        UserAccount account = this.validateUser(name);
        if (!account.isEnabled()) {
            return false;
        }
        account.setEnabled(false);
        this.mergeAccount(account);
        return true;
    }

    @Override
    public List<String> getGrantedRoles(String name) {
        UserAccount account = this.validateUser(name);
        ArrayList<String> roles = new ArrayList<String>();
        for (UserAccount membership : account.getMemberships()) {
            if (!membership.getAccountType().equals((Object)UserAccount.AccountType.role)) continue;
            roles.add(membership.getUsername());
        }
        return roles;
    }

    @Override
    public List<String> getImpliedRoles(String name) {
        UserAccount account = this.validateUser(name);
        HashSet<String> roles = new HashSet<String>();
        for (UserAccount membership : account.getMemberships()) {
            if (!membership.getAccountType().equals((Object)UserAccount.AccountType.role)) continue;
            this.addRoleAndMemberships(membership.getUsername(), roles);
        }
        return new ArrayList<String>(roles);
    }

    private void addRoleAndMemberships(String role, Set<String> roles) {
        UserAccount roleAccount = this.validateRole(role);
        roles.add(role);
        for (UserAccount membership : roleAccount.getMemberships()) {
            if (roles.contains(membership.getUsername())) continue;
            this.addRoleAndMemberships(membership.getUsername(), roles);
        }
    }

    @Override
    public boolean authenticate(String username, String password) {
        UserAccount account = this.validateUser(username);
        if (account == null || !account.getAccountType().equals((Object)UserAccount.AccountType.user) || !account.isEnabled()) {
            return false;
        }
        return this.hashPassword(password).equals(account.getPasswordHash());
    }

    protected UserAccount validateUser(String name) {
        try {
            return (UserAccount)this.getEntityManager().createQuery("from " + this.accountClass.getName() + " where username = :username and " + "accountType = :accountType").setParameter("username", (Object)name).setParameter("accountType", (Object)UserAccount.AccountType.user).getSingleResult();
        }
        catch (NoResultException ex) {
            throw new IdentityManagementException("No such user: " + name);
        }
    }

    protected UserAccount validateRole(String name) {
        for (UserAccount ua : this.roleCache) {
            if (!ua.getUsername().equals(name)) continue;
            return ua;
        }
        try {
            UserAccount role = (UserAccount)this.getEntityManager().createQuery("from " + this.accountClass.getName() + " where username = :username and " + "accountType = :accountType").setParameter("username", (Object)name).setParameter("accountType", (Object)UserAccount.AccountType.role).getSingleResult();
            this.roleCache.add(role);
            return role;
        }
        catch (NoResultException ex) {
            throw new IdentityManagementException("No such role: " + name);
        }
    }

    @Override
    public List<String> listUsers() {
        return this.getEntityManager().createQuery("select username from " + this.accountClass.getName() + " where accountType = :accountType").setParameter("accountType", (Object)UserAccount.AccountType.user).getResultList();
    }

    @Override
    public List<String> listUsers(String filter) {
        return this.getEntityManager().createQuery("select username from " + this.accountClass.getName() + " where accountType = :accountType and lower(username) like :username").setParameter("accountType", (Object)UserAccount.AccountType.user).setParameter("username", (Object)("%" + (filter != null ? filter.toLowerCase() : "") + "%")).getResultList();
    }

    @Override
    public List<String> listRoles() {
        return this.getEntityManager().createQuery("select username from " + this.accountClass.getName() + " where accountType = :accountType").setParameter("accountType", (Object)UserAccount.AccountType.role).getResultList();
    }

    protected void persistAccount(UserAccount account) {
        this.getEntityManager().persist((Object)account);
    }

    protected UserAccount mergeAccount(UserAccount account) {
        return (UserAccount)this.getEntityManager().merge((Object)account);
    }

    private EntityManager getEntityManager() {
        return (EntityManager)Component.getInstance(this.entityManagerName);
    }

    public String getEntityManagerName() {
        return this.entityManagerName;
    }

    public void setEntityManagerName(String name) {
        this.entityManagerName = name;
    }

    public Class<? extends UserAccount> getAccountClass() {
        return this.accountClass;
    }

    public void setAccountClass(Class<? extends UserAccount> accountClass) {
        this.accountClass = accountClass;
    }
}

