/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.SeamTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBUnitSeamTest
extends SeamTest {
    private Log log = Logging.getLog(DBUnitSeamTest.class);
    protected String datasourceJndiName;
    protected List<DataSetOperation> beforeTestOperations = new ArrayList<DataSetOperation>();
    protected List<DataSetOperation> afterTestOperations = new ArrayList<DataSetOperation>();

    protected DBUnitSeamTest() {
    }

    protected DBUnitSeamTest(String datasourceJndiName) {
        this.datasourceJndiName = datasourceJndiName;
    }

    @BeforeClass
    @Parameters(value={"datasourceJndiName"})
    public void setDatasourceJndiName(String datasourceJndiName) {
        this.datasourceJndiName = datasourceJndiName;
    }

    @Override
    @BeforeClass
    public void init() throws Exception {
        super.init();
        this.prepareDBUnitOperations();
    }

    @Override
    @BeforeMethod
    public void begin() {
        super.begin();
        this.executeOperations(this.beforeTestOperations);
    }

    @Override
    @AfterMethod
    public void end() {
        super.end();
        this.executeOperations(this.afterTestOperations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOperations(List<DataSetOperation> list) {
        IDatabaseConnection con = null;
        try {
            con = this.getConnection();
            this.disableReferentialIntegrity(con);
            for (DataSetOperation op : list) {
                this.log.info((Object)("executing DBUnit operation: " + op), new Object[0]);
                op.execute(con);
            }
            this.enableReferentialIntegrity(con);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    protected IDatabaseConnection getConnection() {
        try {
            DataSource datasource = (DataSource)this.getInitialContext().lookup(this.datasourceJndiName);
            Connection con = datasource.getConnection();
            DatabaseConnection dbUnitCon = new DatabaseConnection(con);
            this.editConfig(dbUnitCon.getConfig());
            return dbUnitCon;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void disableReferentialIntegrity(IDatabaseConnection con) {
        try {
            con.getConnection().prepareStatement("set referential_integrity FALSE").execute();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void enableReferentialIntegrity(IDatabaseConnection con) {
        try {
            con.getConnection().prepareStatement("set referential_integrity TRUE").execute();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void editConfig(DatabaseConfig config) {
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory(){

            public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
                if (sqlType == 16) {
                    return DataType.BOOLEAN;
                }
                return super.createDataType(sqlType, sqlTypeName);
            }
        });
    }

    protected abstract void prepareDBUnitOperations();

    protected class DataSetOperation {
        String dataSetLocation;
        ReplacementDataSet dataSet;
        DatabaseOperation operation;

        public DataSetOperation(String dataSetLocation) {
            this(dataSetLocation, DatabaseOperation.CLEAN_INSERT);
        }

        public DataSetOperation(String dataSetLocation, DatabaseOperation operation) {
            DBUnitSeamTest.this.log.info((Object)("preparing dataset: " + dataSetLocation), new Object[0]);
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(dataSetLocation);
            try {
                this.dataSet = new ReplacementDataSet((IDataSet)new FlatXmlDataSet(input));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.dataSet.addReplacementObject((Object)"[NULL]", null);
            this.operation = operation;
            this.dataSetLocation = dataSetLocation;
        }

        public IDataSet getDataSet() {
            return this.dataSet;
        }

        public DatabaseOperation getOperation() {
            return this.operation;
        }

        public void execute(IDatabaseConnection connection) {
            try {
                this.operation.execute(connection, (IDataSet)this.dataSet);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return this.operation.getClass() + " with dataset: " + this.dataSetLocation;
        }
    }
}

