/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.seam.deployment.ComponentScanner;
import org.jboss.seam.init.RedeployableStrategy;

class JavaHotRedeployable
implements RedeployableStrategy {
    protected File[] paths;
    protected ClassLoader classLoader;

    public JavaHotRedeployable(File directory) {
        try {
            if (directory.exists()) {
                URL url = directory.toURL();
                URL[] urls = new URL[]{url};
                this.classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                this.paths = new File[]{directory};
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File[] getPaths() {
        return this.paths;
    }

    public ComponentScanner getScanner() {
        return this.classLoader != null ? new ComponentScanner(null, this.classLoader) : null;
    }

    public boolean isFromHotDeployClassLoader(Class componentClass) {
        return componentClass.getClassLoader() == this.classLoader;
    }
}

