/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.Utils;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class WildcardDictionary
extends Dictionary<Object, Object> {
    private final Vector<Object> keys = new Vector();
    private final Vector<Object> elements = new Vector();

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Enumeration<Object> keys() {
        return this.keys.elements();
    }

    @Override
    public Enumeration<Object> elements() {
        return this.elements.elements();
    }

    @Override
    public synchronized Object get(Object key) {
        String sKey = (String)key;
        int matching_len = 0;
        int found = -1;
        for (int i = this.keys.size() - 1; i > -1; --i) {
            String thisKey = (String)this.keys.elementAt(i);
            int current = Utils.matchSpan(thisKey, sKey);
            if (current <= matching_len) continue;
            found = i;
            matching_len = current;
        }
        if (found > -1) {
            return this.elements.elementAt(found);
        }
        return null;
    }

    public static String trimPathSeparators(String src) {
        StringBuffer result = new StringBuffer(src.length());
        boolean ms = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c == '/' || c == '\\') {
                if (ms) continue;
                result.append(c);
                ms = true;
                continue;
            }
            result.append(c);
            ms = false;
        }
        return result.toString();
    }

    @Override
    public synchronized Object put(Object key, Object element) {
        int i = this.keys.indexOf(key);
        if (i != -1) {
            Object oldElement = this.elements.elementAt(i);
            this.elements.setElementAt(element, i);
            return oldElement;
        }
        this.keys.addElement(key);
        this.elements.addElement(element);
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        int i = this.keys.indexOf(key);
        if (i != -1) {
            Object oldElement = this.elements.elementAt(i);
            this.keys.removeElementAt(i);
            this.elements.removeElementAt(i);
            return oldElement;
        }
        return null;
    }
}

