/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import java.security.AccessController;
import java.util.StringTokenizer;
import org.jboss.resteasy.spi.config.Configuration;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

public class WhiteListPolymorphicTypeValidatorBuilder
extends BasicPolymorphicTypeValidator.Builder {
    private static final long serialVersionUID = 464558058341488449L;
    private static final String BASE_TYPE_PROP = "resteasy.jackson.deserialization.whitelist.allowIfBaseType";
    private static final String SUB_TYPE_PROP = "resteasy.jackson.deserialization.whitelist.allowIfSubType";

    public WhiteListPolymorphicTypeValidatorBuilder() {
        String allowIfSubType;
        String allowIfBaseType = WhiteListPolymorphicTypeValidatorBuilder.getProperty(BASE_TYPE_PROP);
        if (allowIfBaseType != null) {
            StringTokenizer st = new StringTokenizer(allowIfBaseType, ",", false);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                this.allowIfBaseType("*".equals(t) ? "" : t);
            }
        }
        if ((allowIfSubType = WhiteListPolymorphicTypeValidatorBuilder.getProperty(SUB_TYPE_PROP)) != null) {
            StringTokenizer st = new StringTokenizer(allowIfSubType, ",", false);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                this.allowIfSubType("*".equals(t) ? "" : t);
            }
        }
    }

    private static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            Configuration config = ConfigurationFactory.getInstance().getConfiguration();
            return config.getOptionalValue(name, String.class).or(() -> config.getOptionalValue(name + ".prefix", String.class)).orElse(null);
        }
        return AccessController.doPrivileged(() -> {
            Configuration config = ConfigurationFactory.getInstance().getConfiguration();
            return config.getOptionalValue(name, String.class).or(() -> config.getOptionalValue(name + ".prefix", String.class)).orElse(null);
        });
    }
}

