/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.domain.threadpool;

import org.jboss.profileservice.domain.RefMetaData;

import javax.xml.bind.annotation.XmlType;


import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "thread", propOrder = {})
public final class ThreadMetaData
{
    private String name;
    private Boolean daemon;
    private Integer priority;
    private RefMetaData task;
    private RefMetaData threadFactory;
    private RefMetaData exceptionHandler;
    // TODO: private TaskFilterMetaData taskFilter;

    public String getName() {
        return name;
    }

    @XmlAttribute(required = true)
    public void setName(final String name) {
        this.name = name;
    }

    public Boolean isDaemon() {
        return daemon;
    }

    @XmlAttribute
    public void setDaemon(final Boolean daemon) {
        this.daemon = daemon;
    }

    public Integer getPriority() {
        return priority;
    }

    @XmlAttribute
    public void setPriority(final Integer priority) {
        this.priority = priority;
    }

    public RefMetaData getTask() {
        return task;
    }

    @XmlElement(required = true)
    public void setTask(final RefMetaData task) {
        this.task = task;
    }

    public RefMetaData getThreadFactory() {
        return threadFactory;
    }

    @XmlElement(name = "thread-factory", required = true)
    public void setThreadFactory(final RefMetaData threadFactory) {
        this.threadFactory = threadFactory;
    }

    public RefMetaData getExceptionHandler() {
        return exceptionHandler;
    }

    @XmlElement(name = "exception-handler")
    public void setExceptionHandler(final RefMetaData exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

}

