/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.domain;

import java.util.Set;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * Meta information for the local server.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
@JBossXmlSchema(namespace=DomainMetaData.SERVER_NAMESPACE,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true,
      replacePropertyRefs=false)
@XmlRootElement(name = "server")
@XmlType(name = "serverType", propOrder = {"properties", "shutdownTimeout"})
public class ServerMetaData
   implements DomainMetaDataFragment
{

   /** The server name. */
   private String name;
   private String ns;
   private Set<Property> properties;
   private long shutdownTimeout;

   public ServerMetaData()
   {

   }
   
   public ServerMetaData(String name)
   {
      this.name = name;
   }
   
   /** 
    * Get the server name.
    * 
    * @return the server name
    */
   @XmlAttribute(name = "name")
   public String getName()
   {
      return name;
   }
   public void setName(String name)
   {
      this.name = name;
   }

   @XmlElementWrapper(name="properties")
   @XmlElement(name="property")
   public Set<Property> getProperties()
   {
      return properties;
   }
   public void setProperties(Set<Property> properties)
   {
      this.properties = properties;
   }

   @XmlElement(name="shutdown-timeout")
   public void setShutdownTimeout(long shutdownTimeout)
   {
      this.shutdownTimeout = shutdownTimeout;
   }
   public long getShutdownTimeout()
   {
      return shutdownTimeout;
   }

   @Override
   public String getNameSpace()
   {
      return ns;
   }
   public void setNameSpace(String ns)
   {
      this.ns = ns;
   }

   @Override
   public void visit(DomainMetaDataFragmentVisitor visitor)
   {
      // TODO Auto-generated method stub
      
   }
}
