/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui.update;

import java.io.File;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class ForgeUpdateAbortCommand
extends AbstractUICommand {
    public boolean isEnabled(UIContext context) {
        UIProvider provider = context.getProvider();
        if (!provider.isEmbedded() && !provider.isGUI()) {
            File forgeHomeDir = OperatingSystemUtils.getForgeHomeDir();
            if (forgeHomeDir == null) {
                return false;
            }
            File updateDir = new File(forgeHomeDir, ".update");
            return updateDir.exists();
        }
        return false;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Forge: Update Abort").description("Aborts a previous forge update").category(Categories.create((String[])new String[]{"Forge", "Manage"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ResourceFactory resourceFactory = (ResourceFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ResourceFactory.class).get();
        DirectoryResource forgeHome = (DirectoryResource)resourceFactory.create(DirectoryResource.class, (Object)OperatingSystemUtils.getForgeHomeDir());
        DirectoryResource updateDirectory = forgeHome.getChildDirectory(".update");
        if (updateDirectory.exists()) {
            if (updateDirectory.delete(true)) {
                return Results.success((String)"Update files were deleted. Run 'forge-update' if you want to update this installation again.");
            }
            return Results.fail((String)"Could not abort. Try to run 'forge-update-abort' again");
        }
        return Results.success((String)"No update files found");
    }
}

