/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtils {
    public static final void checkClassName(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("Null class name");
        }
        if (className.trim().length() == 0) {
            throw new ClassNotFoundException("Empty class name '" + className + "'");
        }
    }

    public static final String classNameToPath(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        return className.replace('.', '/') + ".class";
    }

    public static final String classNameToPath(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        return ClassLoaderUtils.classNameToPath(clazz.getName());
    }

    public static final String resourceNameToClassName(String resourceName) {
        if (!resourceName.endsWith(".class")) {
            return null;
        }
        resourceName = resourceName.substring(0, resourceName.length() - 6);
        return resourceName.replace('/', '.');
    }

    public static final String packageNameToPath(String className) {
        String packageName = ClassLoaderUtils.getClassPackageName(className);
        return packageName.replace('.', '/');
    }

    public static final String getClassPackageName(String className) {
        int end = className.lastIndexOf(46);
        if (end == -1) {
            return "";
        }
        return className.substring(0, end);
    }

    public static final String getResourcePackageName(String className) {
        int i = className.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        return className.substring(0, i).replace('/', '.');
    }

    public static final byte[] loadByteCode(String name, InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) >= 0) {
                baos.write(tmp, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load class byte code " + name, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadBytes(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) >= 0) {
                baos.write(tmp, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public static final String classToString(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        ClassLoaderUtils.classToString(clazz, builder);
        return builder.toString();
    }

    public static final void classToString(Class<?> clazz, StringBuilder builder) {
        if (clazz == null) {
            builder.append("null");
            return;
        }
        builder.append(clazz);
        builder.append('{');
        ClassLoader cl = ClassLoaderUtils.getClassLoader(clazz);
        builder.append("cl=").append(cl);
        builder.append(" codeSource=");
        builder.append(ClassLoaderUtils.getCodeSource(clazz));
        builder.append("}");
    }

    private static final ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    private static final ProtectionDomain getProtectionDomain(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getProtectionDomain();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
    }

    private static final CodeSource getCodeSource(Class<?> clazz) {
        ProtectionDomain protectionDomain = ClassLoaderUtils.getProtectionDomain(clazz);
        if (protectionDomain == null) {
            return null;
        }
        return protectionDomain.getCodeSource();
    }
}

