/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.jsf;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.faces.event.PhaseId;
import org.jboss.arquillian.warp.jsf.AfterPhase;
import org.jboss.arquillian.warp.jsf.BeforePhase;
import org.jboss.arquillian.warp.jsf.Phase;
import org.jboss.arquillian.warp.jsf.When;
import org.jboss.arquillian.warp.spi.WarpLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhaseLifecycleEvent
extends WarpLifecycleEvent {
    private Phase phase;
    private When when;

    private PhaseLifecycleEvent(Phase phase, When when) {
        this.phase = phase;
        this.when = when;
    }

    public List<Annotation> getQualifiers() {
        switch (this.when) {
            case BEFORE: {
                return Arrays.asList(new BeforePhase(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return BeforePhase.class;
                    }

                    @Override
                    public Phase value() {
                        return PhaseLifecycleEvent.this.phase;
                    }
                });
            }
            case AFTER: {
                return Arrays.asList(new AfterPhase(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return AfterPhase.class;
                    }

                    @Override
                    public Phase value() {
                        return PhaseLifecycleEvent.this.phase;
                    }
                });
            }
        }
        throw new IllegalStateException();
    }

    public static PhaseLifecycleEvent getInstance(PhaseId phaseId, When when) {
        if (when == When.BEFORE) {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                return new BeforeApplyRequestValues();
            }
            if (phaseId == PhaseId.INVOKE_APPLICATION) {
                return new BeforeInvokeApplication();
            }
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                return new BeforeProcessValidations();
            }
            if (phaseId == PhaseId.RENDER_RESPONSE) {
                return new BeforeRenderResponse();
            }
            if (phaseId == PhaseId.RESTORE_VIEW) {
                return new BeforeRestoreView();
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                return new BeforeUpdateModelValues();
            }
        } else {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                return new AfterApplyRequestValues();
            }
            if (phaseId == PhaseId.INVOKE_APPLICATION) {
                return new AfterInvokeApplication();
            }
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                return new AfterProcessValidations();
            }
            if (phaseId == PhaseId.RENDER_RESPONSE) {
                return new AfterRenderResponse();
            }
            if (phaseId == PhaseId.RESTORE_VIEW) {
                return new AfterRestoreView();
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                return new AfterUpdateModelValues();
            }
        }
        throw new IllegalStateException("Unsupported phaseId: " + phaseId + " when: " + (Object)((Object)when));
    }

    public static class AfterUpdateModelValues
    extends PhaseLifecycleEvent {
        public AfterUpdateModelValues() {
            super(Phase.UPDATE_MODEL_VALUES, When.AFTER);
        }
    }

    public static class BeforeUpdateModelValues
    extends PhaseLifecycleEvent {
        public BeforeUpdateModelValues() {
            super(Phase.UPDATE_MODEL_VALUES, When.BEFORE);
        }
    }

    public static class AfterRestoreView
    extends PhaseLifecycleEvent {
        public AfterRestoreView() {
            super(Phase.RESTORE_VIEW, When.AFTER);
        }
    }

    public static class BeforeRestoreView
    extends PhaseLifecycleEvent {
        public BeforeRestoreView() {
            super(Phase.RESTORE_VIEW, When.BEFORE);
        }
    }

    public static class AfterRenderResponse
    extends PhaseLifecycleEvent {
        public AfterRenderResponse() {
            super(Phase.RENDER_RESPONSE, When.AFTER);
        }
    }

    public static class BeforeRenderResponse
    extends PhaseLifecycleEvent {
        public BeforeRenderResponse() {
            super(Phase.RENDER_RESPONSE, When.BEFORE);
        }
    }

    public static class AfterProcessValidations
    extends PhaseLifecycleEvent {
        public AfterProcessValidations() {
            super(Phase.PROCESS_VALIDATIONS, When.AFTER);
        }
    }

    public static class BeforeProcessValidations
    extends PhaseLifecycleEvent {
        public BeforeProcessValidations() {
            super(Phase.PROCESS_VALIDATIONS, When.BEFORE);
        }
    }

    public static class AfterInvokeApplication
    extends PhaseLifecycleEvent {
        public AfterInvokeApplication() {
            super(Phase.INVOKE_APPLICATION, When.AFTER);
        }
    }

    public static class BeforeInvokeApplication
    extends PhaseLifecycleEvent {
        public BeforeInvokeApplication() {
            super(Phase.INVOKE_APPLICATION, When.BEFORE);
        }
    }

    public static class AfterApplyRequestValues
    extends PhaseLifecycleEvent {
        public AfterApplyRequestValues() {
            super(Phase.APPLY_REQUEST_VALUES, When.AFTER);
        }
    }

    public static class BeforeApplyRequestValues
    extends PhaseLifecycleEvent {
        public BeforeApplyRequestValues() {
            super(Phase.APPLY_REQUEST_VALUES, When.BEFORE);
        }
    }
}

