/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.jsf;

import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FacesContextWrapper;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.arquillian.warp.jsf.FacesContextInitialized;
import org.jboss.arquillian.warp.jsf.WarpJSFCommons;
import org.jboss.arquillian.warp.spi.LifecycleManager;
import org.jboss.arquillian.warp.spi.LifecycleManagerStore;
import org.jboss.arquillian.warp.spi.exception.ObjectAlreadyAssociatedException;
import org.jboss.arquillian.warp.spi.exception.ObjectNotAssociatedException;

public class FacesContextFactoryWrapper
extends FacesContextFactory {
    public static final String WARP_ENABLED = FacesContextFactoryWrapper.class.getName() + ".ENABLED";
    private Logger log = WarpJSFCommons.LOG;
    private FacesContextFactory delegate;

    public FacesContextFactoryWrapper(FacesContextFactory facesContextFactory) {
        this.delegate = facesContextFactory;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        Object facesContext = this.delegate.getFacesContext(context, request, response, lifecycle);
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpReq = (HttpServletRequest)request;
            facesContext = new WrappedFacesContext((FacesContext)facesContext);
            facesContext.getAttributes().put(WARP_ENABLED, Boolean.FALSE);
            try {
                LifecycleManager manager = LifecycleManagerStore.get(ServletRequest.class, (Object)httpReq);
                manager.bindTo(FacesContext.class, facesContext);
                facesContext.getAttributes().put(WARP_ENABLED, Boolean.TRUE);
                manager.fireEvent((Object)new FacesContextInitialized((FacesContext)facesContext));
            }
            catch (ObjectNotAssociatedException e) {
                this.log.fine("no association of manager found for this ServletRequest");
            }
            catch (ObjectAlreadyAssociatedException e) {
                throw new IllegalStateException(e);
            }
        }
        return facesContext;
    }

    public class WrappedFacesContext
    extends FacesContextWrapper {
        private FacesContext wrapped;

        public WrappedFacesContext(FacesContext wrapped) {
            this.wrapped = wrapped;
        }

        public FacesContext getWrapped() {
            return this.wrapped;
        }

        public void release() {
            try {
                if (((Boolean)this.getAttributes().get(WARP_ENABLED)).booleanValue()) {
                    LifecycleManager manager = LifecycleManagerStore.get(FacesContext.class, (Object)((Object)this));
                    manager.unbindFrom(FacesContext.class, (Object)this);
                }
            }
            catch (ObjectNotAssociatedException e) {
                throw new IllegalStateException(e);
            }
            finally {
                super.release();
            }
        }
    }
}

