/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.aop.util.reference;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/**
 * @author <a href="flavia.rainone@jboss.com">Flavia Rainone</a>
 * @version $Revision: 103410 $
 */
class SecurityActions
{
   interface GetDeclaredMethodAction
   {
      Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?>... arguments);
      
      GetDeclaredMethodAction PRIVILEGED = new GetDeclaredMethodAction()
      {
         public Method getDeclaredMethod(final Class<?> clazz, final String methodName, final Class<?>... arguments)
         {
            try
            {
               return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>()
               {
                  public Method run() throws Exception
                  {
                     return clazz.getDeclaredMethod(methodName, arguments);
                  }
               });
            }
            catch (PrivilegedActionException e)
            {
               Exception exception = e.getException();
               if (exception instanceof RuntimeException)
               {
                  throw (RuntimeException) exception;
               }
               throw new RuntimeException("Error getting method " + methodName + " from class " + clazz, exception);
            }
         }
      };

      GetDeclaredMethodAction NON_PRIVILEGED = new GetDeclaredMethodAction()
      {
         public Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?>... arguments)
         {
            try
            {
               return clazz.getDeclaredMethod(methodName, arguments);
            }
            catch (NoSuchMethodException e)
            {
               throw new RuntimeException("Error getting method " + methodName + " from class " + clazz, e);
            }
            catch (SecurityException e)
            {
               throw new RuntimeException("Error getting method " + methodName + " from class " + clazz, e);
            }
         }
      };
   }

   static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?>... arguments)
   {
      if (System.getSecurityManager() == null)
      {
         return GetDeclaredMethodAction.NON_PRIVILEGED.getDeclaredMethod(clazz, methodName, arguments);
      }
      else
      {
         return GetDeclaredMethodAction.PRIVILEGED.getDeclaredMethod(clazz, methodName, arguments);
      }
   }
}
