/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.TypeMapperLazy;

public class OptionalType
extends CollectionType {
    public OptionalType(Type baseJavaType, TypeMapperLazy typeMapperLazy) {
        super(baseJavaType, typeMapperLazy);
    }

    public OptionalType(TypeMapperLazy typeMapperLazy) {
        super((Type)((Object)Optional.class), typeMapperLazy);
    }

    @Override
    public Object map(Object sourceOptional_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(sourceOptional_, mapFunction);
        Optional sourceOptional = (Optional)sourceOptional_;
        return sourceOptional.map(o -> mapFunction.apply(o, new EnumerationAwareOwnerContext(owner)));
    }

    @Override
    public Object map(Object sourceOptional_, Function mapFunction) {
        Validate.argumentsAreNotNull(sourceOptional_, mapFunction);
        Optional sourceOptional = (Optional)sourceOptional_;
        return sourceOptional.map(o -> mapFunction.apply(o));
    }

    @Override
    protected Stream<Object> items(Object source) {
        if (source == null) {
            return Stream.empty();
        }
        Optional sourceOptional = (Optional)source;
        return sourceOptional.map(it -> Stream.of(it)).orElse(Stream.empty());
    }

    @Override
    public boolean isEmpty(Object optional) {
        return optional == null || !((Optional)optional).isPresent();
    }

    @Override
    public Object empty() {
        return Optional.empty();
    }

    @Override
    public Class<?> getEnumerableInterface() {
        return Optional.class;
    }
}

