/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation.length;

import java.util.Locale;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.ValidatorAdapter;
import org.javalite.activejdbc.validation.length.LengthOption;

public class AttributeLengthValidator
extends ValidatorAdapter {
    private final String attribute;
    private LengthOption lengthOption;
    private boolean allowBlank;

    private AttributeLengthValidator(String attribute) {
        this.attribute = attribute;
    }

    public static AttributeLengthValidator on(String attribute) {
        return new AttributeLengthValidator(attribute);
    }

    @Override
    public void validate(Model m) {
        Object value = m.get(this.attribute);
        if (this.allowBlank && (null == value || "".equals(value))) {
            return;
        }
        if (null == value) {
            m.addValidator(this, this.attribute);
            return;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Attribute must be a String");
        }
        if (!this.lengthOption.validate((String)m.get(this.attribute))) {
            m.addValidator(this, this.attribute);
        }
    }

    public AttributeLengthValidator with(LengthOption lengthOption) {
        this.lengthOption = lengthOption;
        this.setMessage(lengthOption.getParametrizedMessage());
        return this;
    }

    public AttributeLengthValidator allowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
        return this;
    }

    @Override
    public String formatMessage(Locale locale, Object ... params) {
        return super.formatMessage(locale, this.lengthOption.getMessageParameters());
    }
}

