/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.ValidatorAdapter;
import org.javalite.common.Util;

public class TimestampValidator
extends ValidatorAdapter {
    private String attributeName;
    private String format;
    private SimpleDateFormat df;

    public TimestampValidator(String attributeName, String format) {
        this.attributeName = attributeName;
        this.message = "attribute {0} does not conform to format: {1}";
        this.df = new SimpleDateFormat(format);
        this.format = format;
    }

    @Override
    public void validate(Model m) {
        Object val = m.get(this.attributeName);
        if (!(val instanceof Timestamp) && !Util.blank((Object)val)) {
            try {
                long time = this.df.parse(val.toString()).getTime();
                Timestamp t = new Timestamp(time);
                m.set(this.attributeName, (Object)t);
            }
            catch (ParseException e) {
                m.addValidator(this, this.attributeName);
            }
        }
    }

    @Override
    public String formatMessage(Locale locale, Object ... params) {
        return super.formatMessage(locale, this.attributeName, this.format);
    }
}

