/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.common.Convert;

public class OracleDialect
extends DefaultDialect {
    @Override
    public String formSelect(String tableName, String[] columns, String subQuery, List<String> orderBys, long limit, long offset) {
        boolean needLimit = limit != -1L;
        boolean needOffset = offset != -1L;
        StringBuilder fullQuery = new StringBuilder();
        if (needOffset) {
            fullQuery.append("SELECT * FROM (SELECT t2.*, ROWNUM AS oracle_row_number FROM (");
        } else if (needLimit) {
            fullQuery.append("SELECT * FROM (SELECT t2.* FROM (");
        }
        this.appendSelect(fullQuery, tableName, columns, null, subQuery, orderBys);
        if (needOffset) {
            fullQuery.append(") t2) WHERE oracle_row_number >= ").append(offset + 1L);
            if (needLimit) {
                fullQuery.append(" AND ROWNUM <= ").append(limit);
            }
        } else if (needLimit) {
            fullQuery.append(") t2) WHERE ROWNUM <= ").append(limit);
        }
        return fullQuery.toString();
    }

    @Override
    public Object overrideDriverTypeConversion(MetaModel mm, String attributeName, Object value) {
        String typeName;
        if (value instanceof Timestamp && "DATE".equalsIgnoreCase(typeName = mm.getColumnMetadata().get(attributeName).getTypeName())) {
            return Convert.toSqlDate((Object)value);
        }
        return value;
    }

    @Override
    protected void appendEmptyRow(MetaModel metaModel, StringBuilder query) {
        query.append('(').append(metaModel.getIdName()).append(") VALUES (").append(metaModel.getIdGeneratorCode() != null ? metaModel.getIdGeneratorCode() : "NULL").append(')');
    }

    @Override
    protected void appendTime(StringBuilder query, Time value) {
        this.appendTimestamp(query, new Timestamp(value.getTime()));
    }
}

