/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.connection_config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.connection_config.ConnectionConfig;
import org.javalite.activejdbc.connection_config.ConnectionJdbcConfig;
import org.javalite.activejdbc.connection_config.ConnectionJndiConfig;
import org.javalite.app_config.AppConfig;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConfiguration {
    private static Logger LOGGER = LoggerFactory.getLogger(DBConfiguration.class);
    private static HashMap<String, ArrayList<ConnectionConfig>> connectionConfigs = new HashMap();

    public static void addConnectionConfig(ConnectionConfig connectionConfig, boolean override) {
        DBConfiguration.addConnectionConfig(connectionConfig);
    }

    public static void addConnectionConfig(ConnectionConfig connectionConfig) {
        String connectionEnv = connectionConfig.getEnvironment();
        ArrayList connectionConfigList = connectionConfigs.computeIfAbsent(connectionEnv, k -> new ArrayList());
        for (ConnectionConfig config : (List)connectionConfigList.clone()) {
            if (!config.getDbName().equals(connectionConfig.getDbName()) || !config.getEnvironment().equals(connectionConfig.getEnvironment()) || config.isTesting() != connectionConfig.isTesting()) continue;
            LOGGER.info("Removing: " + connectionConfig);
            connectionConfigList.remove(config);
        }
        LOGGER.info("Adding: " + connectionConfig);
        connectionConfigList.add(connectionConfig);
    }

    public static List<ConnectionConfig> getConnectionConfigsForCurrentEnv() {
        return DBConfiguration.getConnectionConfigs(AppConfig.activeEnv());
    }

    public static List<ConnectionConfig> getConnectionConfigs(String env) {
        return connectionConfigs.get(env) == null ? new ArrayList<ConnectionConfig>() : (List)connectionConfigs.get(env).clone();
    }

    public static List<ConnectionConfig> getConnectionConfigsExceptTesting(String dbName) {
        if (dbName == null) {
            throw new IllegalArgumentException("dbName cannot be null");
        }
        List<ConnectionConfig> allConnections = DBConfiguration.getConnectionConfigsForCurrentEnv();
        LinkedList<ConnectionConfig> result = new LinkedList<ConnectionConfig>();
        for (ConnectionConfig connectionConfig : allConnections) {
            if (connectionConfig.isTesting() || !dbName.equals(connectionConfig.getDbName())) continue;
            result.add(connectionConfig);
        }
        return result;
    }

    public static void clearConnectionConfigs() {
        DBConfiguration.clearConnectionConfigs(AppConfig.activeEnv());
    }

    public static void resetConnectionConfigs() {
        connectionConfigs = new HashMap();
    }

    protected static void clearConnectionConfigs(String env) {
        if (connectionConfigs.get(env) != null) {
            connectionConfigs.get(env).clear();
        }
    }

    public static void loadConfiguration(String file) {
        try {
            Properties props = Util.readProperties((String)file);
            Set environments = props.stringPropertyNames().stream().map(n -> n.substring(0, n.lastIndexOf("."))).collect(Collectors.toSet());
            for (String env : environments) {
                String jndiName = env + ".jndi";
                if (props.containsKey(jndiName)) {
                    DBConfiguration.createJndiConfig(env, props.getProperty(jndiName));
                    continue;
                }
                String driver = props.getProperty(env + ".driver");
                String userName = props.getProperty(env + ".username");
                String password = props.getProperty(env + ".password");
                String url = props.getProperty(env + ".url");
                DBConfiguration.checkProps(driver, userName, password, url, env);
                DBConfiguration.createJdbcConfig(env, driver, url, userName, password);
            }
        }
        catch (InitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException(e);
        }
        DBConfiguration.overrideFromEnvironmentVariables();
        DBConfiguration.overrideFromSystemProperties();
    }

    private static void checkProps(String driver, String userName, String password, String url, String env) {
        if (driver == null || userName == null || password == null || url == null) {
            throw new InitException("Four JDBC properties are expected: driver, username, password, url for environment: " + env);
        }
    }

    private static void createJdbcConfig(String env, String driver, String url, String userName, String password) {
        ConnectionJdbcConfig connectionJdbcConfig = new ConnectionJdbcConfig(driver, url, userName, password);
        connectionJdbcConfig.setEnvironment(env);
        if (env.equals("test")) {
            connectionJdbcConfig.setEnvironment("development");
            connectionJdbcConfig.setTesting(true);
        } else if (env.endsWith(".test")) {
            connectionJdbcConfig.setEnvironment(env.split("\\.")[0]);
            connectionJdbcConfig.setTesting(true);
        } else {
            connectionJdbcConfig.setEnvironment(env);
        }
        DBConfiguration.addConnectionConfig(connectionJdbcConfig);
    }

    private static void createJndiConfig(String env, String jndiName) {
        ConnectionJndiConfig connectionJndiConfig = new ConnectionJndiConfig(jndiName);
        connectionJndiConfig.setEnvironment(env);
        DBConfiguration.addConnectionConfig(connectionJndiConfig);
    }

    public List<ConnectionConfig> getTestConnectionConfigs() {
        return DBConfiguration.getConnectionConfigsForCurrentEnv().stream().filter(ConnectionConfig::isTesting).collect(Collectors.toList());
    }

    private static void overrideFromEnvironmentVariables() {
        String jndi;
        String url = System.getenv("ACTIVEJDBC.URL");
        String user = System.getenv("ACTIVEJDBC.USER");
        String password = System.getenv("ACTIVEJDBC.PASSWORD");
        String driver = System.getenv("ACTIVEJDBC.DRIVER");
        if (!(Util.blank((Object)url) || Util.blank((Object)user) || Util.blank((Object)password) || Util.blank((Object)driver))) {
            ConnectionJdbcConfig jdbcConfig = new ConnectionJdbcConfig(driver, url, user, password);
            jdbcConfig.setEnvironment(AppConfig.activeEnv());
            DBConfiguration.addConnectionConfig(jdbcConfig);
        }
        if (!Util.blank((Object)(jndi = System.getenv("ACTIVEJDBC.JNDI")))) {
            ConnectionJndiConfig jndiConfig = new ConnectionJndiConfig(jndi);
            jndiConfig.setEnvironment(AppConfig.activeEnv());
            DBConfiguration.addConnectionConfig(jndiConfig);
        }
    }

    private static void overrideFromSystemProperties() {
        String jndi;
        String url = System.getProperty("activejdbc.url");
        String user = System.getProperty("activejdbc.user");
        String password = System.getProperty("activejdbc.password");
        String driver = System.getProperty("activejdbc.driver");
        if (!(Util.blank((Object)url) || Util.blank((Object)user) || Util.blank((Object)driver))) {
            ConnectionJdbcConfig jdbcConfig = new ConnectionJdbcConfig(driver, url, user, password);
            jdbcConfig.setEnvironment(AppConfig.activeEnv());
            DBConfiguration.addConnectionConfig(jdbcConfig);
        }
        if (!Util.blank((Object)(jndi = System.getProperty("activejdbc.jndi")))) {
            ConnectionJndiConfig jndiConfig = new ConnectionJndiConfig(jndi);
            jndiConfig.setEnvironment(AppConfig.activeEnv());
            DBConfiguration.addConnectionConfig(jndiConfig);
        }
    }
}

