/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring2.properties;

import java.util.Properties;
import org.jasypt.commons.CommonUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.web.context.support.ServletContextPropertyPlaceholderConfigurer;

public final class EncryptableServletContextPropertyPlaceholderConfigurer
extends ServletContextPropertyPlaceholderConfigurer {
    private final StringEncryptor stringEncryptor;
    private final TextEncryptor textEncryptor;

    public EncryptableServletContextPropertyPlaceholderConfigurer(StringEncryptor stringEncryptor) {
        CommonUtils.validateNotNull((Object)stringEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = stringEncryptor;
        this.textEncryptor = null;
    }

    public EncryptableServletContextPropertyPlaceholderConfigurer(TextEncryptor textEncryptor) {
        CommonUtils.validateNotNull((Object)textEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = null;
        this.textEncryptor = textEncryptor;
    }

    protected String convertPropertyValue(String originalValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue((String)originalValue)) {
            return originalValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt((String)originalValue, (StringEncryptor)this.stringEncryptor);
        }
        return PropertyValueEncryptionUtils.decrypt((String)originalValue, (TextEncryptor)this.textEncryptor);
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        return this.convertPropertyValue(super.resolvePlaceholder(placeholder, props));
    }
}

