/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.vertices;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.addedrelations.AddedRelationsContainer;
import org.janusgraph.graphdb.transaction.addedrelations.ConcurrentAddedRelations;
import org.janusgraph.graphdb.transaction.addedrelations.SimpleAddedRelations;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.vertices.AbstractVertex;
import org.janusgraph.util.datastructures.Retriever;

public class StandardVertex
extends AbstractVertex {
    private final Object lifecycleMutex = new Object();
    private volatile byte lifecycle;
    private VertexLabel cachedVertexLabel;
    private volatile AddedRelationsContainer addedRelations = AddedRelationsContainer.EMPTY;

    public StandardVertex(StandardJanusGraphTx tx, Object id, byte lifecycle) {
        super(tx, id);
        this.lifecycle = lifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateLifeCycle(ElementLifeCycle.Event event) {
        Object object = this.lifecycleMutex;
        synchronized (object) {
            this.lifecycle = ElementLifeCycle.update(this.lifecycle, event);
        }
    }

    @Override
    public void removeRelation(InternalRelation r) {
        if (r.isNew()) {
            this.addedRelations.remove(r);
        } else if (r.isLoaded()) {
            this.updateLifeCycle(ElementLifeCycle.Event.REMOVED_RELATION);
        } else {
            throw new IllegalArgumentException("Unexpected relation status: " + r.isRemoved());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRelation(InternalRelation r) {
        Preconditions.checkArgument((boolean)r.isNew(), (Object)"Unexpected relation status: r is not new");
        if (this.addedRelations == AddedRelationsContainer.EMPTY) {
            if (this.tx().getConfiguration().isSingleThreaded()) {
                this.addedRelations = new SimpleAddedRelations(true);
            } else {
                StandardVertex standardVertex = this;
                synchronized (standardVertex) {
                    if (this.addedRelations == AddedRelationsContainer.EMPTY) {
                        this.addedRelations = new ConcurrentAddedRelations(true);
                    }
                }
            }
        }
        if (this.addedRelations.add(r)) {
            this.cacheLabelVertex(r);
            this.updateLifeCycle(ElementLifeCycle.Event.ADDED_RELATION);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<InternalRelation> getDuplicatedAddedRelation(PropertyKey key, Object value) {
        switch (key.cardinality()) {
            case SINGLE: {
                return this.addedRelations.getViewOfProperties(key.name());
            }
            case SET: {
                return this.addedRelations.getViewOfProperties(key.name(), value);
            }
        }
        throw new AssertionError((Object)"Unsupported cardinality for this operation");
    }

    @Override
    public Iterable<InternalRelation> getAddedRelations(Predicate<InternalRelation> query) {
        return this.addedRelations.getView(query);
    }

    @Override
    public Iterable<InternalRelation> findPreviousRelation(long id) {
        return this.addedRelations.getViewOfPreviousRelations(id);
    }

    @Override
    public Iterable<InternalRelation> findAddedProperty(Predicate<InternalRelation> query) {
        return this.addedRelations.getViewOfProperties(query);
    }

    @Override
    public EntryList loadRelations(SliceQuery query, Retriever<SliceQuery, EntryList> lookup) {
        return this.isNew() ? EntryList.EMPTY_LIST : lookup.get(query);
    }

    @Override
    public VertexLabel vertexLabel() {
        if (this.cachedVertexLabel == null) {
            this.cachedVertexLabel = super.vertexLabel();
        }
        return this.cachedVertexLabel;
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        if (this.isNew()) {
            return this.addedRelations.getViewOfProperties(keys).stream().filter(i -> (keys.length != 0 || !i.isInvisible()) && ((JanusGraphVertexProperty)((Object)i)).value() != null).map(i -> (VertexProperty)i).iterator();
        }
        return super.properties(keys);
    }

    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        return false;
    }

    @Override
    public boolean hasRemovedRelations() {
        return ElementLifeCycle.hasRemovedRelations(this.lifecycle);
    }

    @Override
    public boolean hasAddedRelations() {
        return ElementLifeCycle.hasAddedRelations(this.lifecycle);
    }

    @Override
    public synchronized void remove() {
        super.remove();
        ((StandardVertex)this.it()).updateLifeCycle(ElementLifeCycle.Event.REMOVED);
    }

    @Override
    public synchronized void remove(Iterable<JanusGraphRelation> loadedRelations) {
        super.remove(loadedRelations);
        ((StandardVertex)this.it()).updateLifeCycle(ElementLifeCycle.Event.REMOVED);
    }

    @Override
    public byte getLifeCycle() {
        return this.lifecycle;
    }

    private boolean cacheLabelVertex(InternalRelation relation) {
        if (relation.getType().equals(BaseLabel.VertexLabelEdge)) {
            this.cachedVertexLabel = (VertexLabel)((StandardEdge)relation).vertex(Direction.IN);
            return true;
        }
        return false;
    }
}

