/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.janusgraph.graphdb.util.CloseableAbstractIterator;
import org.janusgraph.graphdb.util.CloseableIteratorUtils;

public class MultiDistinctUnorderedIterator<E extends Element>
extends CloseableAbstractIterator<E> {
    private final Set<Object> allElements = new HashSet<Object>();
    private final CloseableIterator<E> iterator;
    private final int limit;
    private final boolean singleIterator;
    private long count;

    public MultiDistinctUnorderedIterator(int lowLimit, int highLimit, List<Iterator<E>> iterators) {
        Objects.requireNonNull(iterators);
        this.iterator = CloseableIteratorUtils.concat(iterators);
        this.limit = highLimit;
        this.singleIterator = iterators.size() == 1;
        for (long i = 0L; i < (long)lowLimit && this.hasNext(); ++i) {
            this.next();
        }
    }

    protected E computeNext() {
        if (this.limit == Integer.MAX_VALUE || this.count < (long)this.limit) {
            while (this.iterator.hasNext()) {
                Element elem = (Element)this.iterator.next();
                if (!this.singleIterator && !this.allElements.add(elem.id())) continue;
                ++this.count;
                return (E)elem;
            }
        }
        this.close();
        return (E)((Element)this.endOfData());
    }

    public void close() {
        this.iterator.close();
    }
}

