/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphDropStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphElementMapStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphLabelStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphPropertiesStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphPropertyMapStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphVertexStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.AdjacentVertexFilterOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryDropStepStrategyMode;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryLabelStepStrategyMode;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryPropertiesStrategyMode;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;

public class JanusGraphLocalQueryOptimizerStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final JanusGraphLocalQueryOptimizerStrategy INSTANCE = new JanusGraphLocalQueryOptimizerStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(AdjacentVertexFilterOptimizerStrategy.class);

    private JanusGraphLocalQueryOptimizerStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        MultiQueryDropStepStrategyMode dropStepStrategyMode;
        MultiQueryLabelStepStrategyMode labelStepStrategyMode;
        MultiQueryPropertiesStrategyMode propertiesStrategyMode;
        int txVertexCacheSize;
        if (!traversal.getGraph().isPresent()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        Optional<StandardJanusGraphTx> tx = JanusGraphTraversalUtil.getJanusGraphTx(traversal);
        if (tx.isPresent()) {
            TransactionConfiguration txConfig = tx.get().getConfiguration();
            txVertexCacheSize = txConfig.getVertexCacheSize();
            propertiesStrategyMode = txConfig.getPropertiesStrategyMode();
            labelStepStrategyMode = txConfig.getLabelStepStrategyMode();
            dropStepStrategyMode = txConfig.getDropStepStrategyMode();
        } else {
            GraphDatabaseConfiguration graphConfig = janusGraph.getConfiguration();
            txVertexCacheSize = graphConfig.getTxVertexCacheSize();
            propertiesStrategyMode = graphConfig.propertiesStrategyMode();
            labelStepStrategyMode = graphConfig.labelStepStrategyMode();
            dropStepStrategyMode = graphConfig.dropStepStrategyMode();
        }
        this.applyJanusGraphVertexSteps(traversal);
        this.applyJanusGraphPropertiesSteps(traversal, txVertexCacheSize, propertiesStrategyMode);
        this.applyJanusGraphLabelSteps(traversal, labelStepStrategyMode);
        this.applyJanusGraphDropSteps(traversal, dropStepStrategyMode);
        this.inspectLocalTraversals(traversal, txVertexCacheSize, propertiesStrategyMode);
    }

    private void applyJanusGraphVertexSteps(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfAssignableClass(VertexStep.class, traversal).forEach(originalStep -> {
            JanusGraphVertexStep vertexStep = new JanusGraphVertexStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, vertexStep, (Traversal.Admin)originalStep.getTraversal());
            if (JanusGraphTraversalUtil.isEdgeReturnStep(vertexStep)) {
                HasStepFolder.foldInHasContainer(vertexStep, originalStep.getTraversal(), originalStep.getTraversal());
            }
            assert (JanusGraphTraversalUtil.isEdgeReturnStep(vertexStep) || JanusGraphTraversalUtil.isVertexReturnStep(vertexStep));
            Step nextStep = JanusGraphTraversalUtil.getNextNonIdentityStep(vertexStep);
            if (nextStep instanceof RangeGlobalStep) {
                int limit = QueryUtil.convertLimit(((RangeGlobalStep)nextStep).getHighRange());
                vertexStep.setLimit(0, QueryUtil.mergeHighLimits(limit, vertexStep.getHighLimit()));
            }
        });
    }

    private void applyJanusGraphPropertiesSteps(Traversal.Admin<?, ?> traversal, int txVertexCacheSize, MultiQueryPropertiesStrategyMode propertiesStrategyMode) {
        JanusGraphTraversalUtil.getSteps(step -> step instanceof PropertiesStep || step instanceof PropertyMapStep || step instanceof ElementMapStep, traversal).forEach(originalStep -> {
            MultiQueriable propertiesPrefetchingStep;
            boolean prefetchAllowed;
            if (originalStep instanceof MultiQueriable) {
                return;
            }
            boolean prefetchAllPropertiesRequired = MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.equals(propertiesStrategyMode);
            boolean bl = prefetchAllowed = !MultiQueryPropertiesStrategyMode.NONE.equals(propertiesStrategyMode);
            if (originalStep instanceof PropertiesStep) {
                JanusGraphPropertiesStep propertiesStep = new JanusGraphPropertiesStep((PropertiesStep)originalStep, prefetchAllPropertiesRequired, prefetchAllowed);
                TraversalHelper.replaceStep((Step)originalStep, propertiesStep, (Traversal.Admin)originalStep.getTraversal());
                if (propertiesStep.getReturnType().forProperties()) {
                    HasStepFolder.foldInHasContainer(propertiesStep, originalStep.getTraversal(), originalStep.getTraversal());
                }
                propertiesPrefetchingStep = propertiesStep;
            } else if (originalStep instanceof PropertyMapStep) {
                JanusGraphPropertyMapStep propertyMapStep = new JanusGraphPropertyMapStep((PropertyMapStep)originalStep, prefetchAllPropertiesRequired, prefetchAllowed);
                TraversalHelper.replaceStep((Step)originalStep, propertyMapStep, (Traversal.Admin)originalStep.getTraversal());
                propertiesPrefetchingStep = propertyMapStep;
            } else if (originalStep instanceof ElementMapStep) {
                JanusGraphElementMapStep elementMapStep = new JanusGraphElementMapStep((ElementMapStep)originalStep, prefetchAllPropertiesRequired, prefetchAllowed);
                TraversalHelper.replaceStep((Step)originalStep, elementMapStep, (Traversal.Admin)originalStep.getTraversal());
                propertiesPrefetchingStep = elementMapStep;
            } else {
                return;
            }
            propertiesPrefetchingStep.setBatchSize(txVertexCacheSize);
        });
    }

    private void inspectLocalTraversals(Traversal.Admin<?, ?> traversal, int txVertexCacheSize, MultiQueryPropertiesStrategyMode propertiesStrategyMode) {
        TraversalHelper.getStepsOfClass(LocalStep.class, traversal).forEach(localStep -> {
            Traversal.Admin localTraversal = (Traversal.Admin)localStep.getLocalChildren().get(0);
            Step localStart = localTraversal.getStartStep();
            if (localStart instanceof VertexStep) {
                JanusGraphVertexStep vertexStep = new JanusGraphVertexStep((VertexStep)localStart);
                vertexStep.setBatchSize(txVertexCacheSize);
                TraversalHelper.replaceStep((Step)localStart, vertexStep, (Traversal.Admin)localTraversal);
                if (JanusGraphTraversalUtil.isEdgeReturnStep(vertexStep)) {
                    HasStepFolder.foldInHasContainer(vertexStep, localTraversal, traversal);
                    HasStepFolder.foldInOrder(vertexStep, vertexStep.getNextStep(), localTraversal, traversal, false, null);
                }
                HasStepFolder.foldInRange(vertexStep, JanusGraphTraversalUtil.getNextNonIdentityStep(vertexStep), localTraversal, null);
                JanusGraphLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, vertexStep);
            } else if (localStart instanceof PropertiesStep) {
                boolean prefetchAllPropertiesRequired = MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.equals(propertiesStrategyMode);
                boolean prefetchAllowed = !MultiQueryPropertiesStrategyMode.NONE.equals(propertiesStrategyMode);
                JanusGraphPropertiesStep propertiesStep = new JanusGraphPropertiesStep((PropertiesStep)localStart, prefetchAllPropertiesRequired, prefetchAllowed);
                propertiesStep.setBatchSize(txVertexCacheSize);
                TraversalHelper.replaceStep((Step)localStart, propertiesStep, (Traversal.Admin)localTraversal);
                if (propertiesStep.getReturnType().forProperties()) {
                    HasStepFolder.foldInHasContainer(propertiesStep, localTraversal, traversal);
                    HasStepFolder.foldInOrder(propertiesStep, propertiesStep.getNextStep(), localTraversal, traversal, false, null);
                }
                HasStepFolder.foldInRange(propertiesStep, JanusGraphTraversalUtil.getNextNonIdentityStep(propertiesStep), localTraversal, null);
                JanusGraphLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, propertiesStep);
            }
        });
    }

    private void applyJanusGraphLabelSteps(Traversal.Admin<?, ?> traversal, MultiQueryLabelStepStrategyMode labelStepStrategyMode) {
        if (MultiQueryLabelStepStrategyMode.NONE.equals(labelStepStrategyMode)) {
            return;
        }
        TraversalHelper.getStepsOfAssignableClass(LabelStep.class, traversal).forEach(originalStep -> {
            if (originalStep instanceof JanusGraphLabelStep) {
                return;
            }
            JanusGraphLabelStep janusGraphLabelStep = new JanusGraphLabelStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, janusGraphLabelStep, (Traversal.Admin)originalStep.getTraversal());
        });
    }

    private void applyJanusGraphDropSteps(Traversal.Admin<?, ?> traversal, MultiQueryDropStepStrategyMode dropStepStrategyMode) {
        if (MultiQueryDropStepStrategyMode.NONE.equals(dropStepStrategyMode)) {
            return;
        }
        TraversalHelper.getStepsOfAssignableClass(DropStep.class, traversal).forEach(originalStep -> {
            if (originalStep instanceof JanusGraphDropStep) {
                return;
            }
            JanusGraphDropStep janusGraphDropStep = new JanusGraphDropStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, janusGraphDropStep, (Traversal.Admin)originalStep.getTraversal());
        });
    }

    private static void unfoldLocalTraversal(Traversal.Admin<?, ?> traversal, LocalStep<?, ?> localStep, Traversal.Admin localTraversal, MultiQueriable vertexStep) {
        assert (localTraversal.asAdmin().getSteps().size() > 0);
        if (localTraversal.asAdmin().getSteps().size() == 1) {
            assert (localTraversal.getStartStep() == vertexStep);
            vertexStep.setTraversal(traversal);
            TraversalHelper.replaceStep(localStep, (Step)vertexStep, traversal);
        }
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static JanusGraphLocalQueryOptimizerStrategy instance() {
        return INSTANCE;
    }
}

