/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Connection;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.CompositeIndexInfo;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphConfiguration;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.JobStatus;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.TransactionalConfiguration;
import org.janusgraph.diskstorage.configuration.UserModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.backend.KCVSConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.EmptyScanJobFuture;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJobFuture;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.keycolumnvalue.scan.StandardScanner;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.cache.SchemaCache;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.JanusGraphIndexWrapper;
import org.janusgraph.graphdb.database.management.ManagementLogger;
import org.janusgraph.graphdb.database.management.MgmtLogType;
import org.janusgraph.graphdb.database.management.ModifierType;
import org.janusgraph.graphdb.database.management.RelationIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.RelationTypeIndexWrapper;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.Token;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.olap.job.GhostVertexRemover;
import org.janusgraph.graphdb.olap.job.IndexRemoveJob;
import org.janusgraph.graphdb.olap.job.IndexRepairJob;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.graphdb.types.StandardPropertyKeyMaker;
import org.janusgraph.graphdb.types.StandardRelationTypeMaker;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.indextype.IndexTypeWrapper;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.SystemTypeManager;
import org.janusgraph.graphdb.types.vertices.EdgeLabelVertex;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.types.vertices.PropertyKeyVertex;
import org.janusgraph.graphdb.types.vertices.RelationTypeVertex;
import org.janusgraph.util.datastructures.IterablesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementSystem
implements JanusGraphManagement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementSystem.class);
    public static final String CURRENT_INSTANCE_SUFFIX = "(current)";
    private final StandardJanusGraph graph;
    private final Log sysLog;
    private final ManagementLogger managementLogger;
    private final TransactionalConfiguration transactionalConfig;
    private final ModifiableConfiguration modifyConfig;
    private final UserModifiableConfiguration userConfig;
    private final SchemaCache schemaCache;
    private final StandardJanusGraphTx transaction;
    private final Set<JanusGraphSchemaVertex> updatedTypes;
    private boolean evictGraphFromCache;
    private final List<Callable<Boolean>> updatedTypeTriggers;
    private final Instant txStartTime;
    private boolean graphShutdownRequired;
    private boolean isOpen;
    private static final String FIRSTDASH = "------------------------------------------------------------------------------------------------\n";
    private static final String DASHBREAK = "---------------------------------------------------------------------------------------------------\n";
    private final UserModifiableConfiguration.ConfigVerifier configVerifier = new UserModifiableConfiguration.ConfigVerifier(){

        @Override
        public void verifyModification(ConfigOption option) {
            Preconditions.checkArgument((ManagementSystem.this.graph.getConfiguration().isUpgradeAllowed(option.getName()) || option.getType() != ConfigOption.Type.FIXED ? 1 : 0) != 0, (String)"Cannot change the fixed configuration option: %s", (Object)option);
            Preconditions.checkArgument((option.getType() != ConfigOption.Type.LOCAL ? 1 : 0) != 0, (String)"Cannot change the local configuration option: %s", (Object)option);
            if (option.getType() == ConfigOption.Type.GLOBAL_OFFLINE) {
                Set<String> openInstances = ManagementSystem.this.getOpenInstancesInternal();
                assert (openInstances.size() > 0);
                Preconditions.checkArgument((openInstances.size() < 2 ? 1 : 0) != 0, (String)"Cannot change offline config option [%s] since multiple instances are currently open: %s", (Object)option, openInstances);
                Preconditions.checkArgument((boolean)openInstances.contains(ManagementSystem.this.graph.getConfiguration().getUniqueGraphId()), (String)"Only one open instance (%s), but it's not the current one (%s)", (Object)openInstances.iterator().next(), (Object)ManagementSystem.this.graph.getConfiguration().getUniqueGraphId());
                ManagementSystem.this.graphShutdownRequired = true;
            }
        }
    };

    public ManagementSystem(StandardJanusGraph graph, KCVSConfiguration config, Log sysLog, ManagementLogger managementLogger, SchemaCache schemaCache) {
        Preconditions.checkArgument((config != null && graph != null && sysLog != null && managementLogger != null ? 1 : 0) != 0);
        this.graph = graph;
        this.sysLog = sysLog;
        this.managementLogger = managementLogger;
        this.schemaCache = schemaCache;
        this.transactionalConfig = new TransactionalConfiguration(config);
        this.modifyConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.transactionalConfig, BasicConfiguration.Restriction.GLOBAL);
        this.userConfig = new UserModifiableConfiguration(this.modifyConfig, this.configVerifier);
        this.updatedTypes = new HashSet<JanusGraphSchemaVertex>();
        this.evictGraphFromCache = false;
        this.updatedTypeTriggers = new ArrayList<Callable<Boolean>>();
        this.graphShutdownRequired = false;
        this.transaction = (StandardJanusGraphTx)graph.buildTransaction().disableBatchLoading().start();
        this.txStartTime = graph.getConfiguration().getTimestampProvider().getTime();
        this.isOpen = true;
    }

    public Set<String> getOpenInstancesInternal() {
        HashSet<String> openInstances = new HashSet<String>(this.modifyConfig.getContainedNamespaces(GraphDatabaseConfiguration.REGISTRATION_NS, new String[0]));
        LOGGER.debug("Open instances: {}", openInstances);
        return openInstances;
    }

    @Override
    public Set<String> getOpenInstances() {
        Set<String> openInstances = this.getOpenInstancesInternal();
        String uid = this.graph.getConfiguration().getUniqueGraphId();
        Preconditions.checkArgument((boolean)openInstances.contains(uid), (String)"Current instance [%s] not listed as an open instance: %s", (Object)uid, openInstances);
        openInstances.remove(uid);
        openInstances.add(uid + CURRENT_INSTANCE_SUFFIX);
        return openInstances;
    }

    @Override
    public void forceCloseInstance(String instanceId) {
        Preconditions.checkArgument((!this.graph.getConfiguration().getUniqueGraphId().equals(instanceId) ? 1 : 0) != 0, (String)"Cannot force close this current instance [%s]. Properly shut down the graph instead.", (Object)instanceId);
        Preconditions.checkArgument((boolean)this.modifyConfig.has(GraphDatabaseConfiguration.REGISTRATION_TIME, instanceId), (String)"Instance [%s] is not currently open", (Object)instanceId);
        Instant registrationTime = this.modifyConfig.get(GraphDatabaseConfiguration.REGISTRATION_TIME, instanceId);
        Preconditions.checkArgument((registrationTime.compareTo(this.txStartTime) < 0 ? 1 : 0) != 0, (String)"The to-be-closed instance [%s] was started after this transactionwhich indicates a successful restart and can hence not be closed: %s vs %s", (Object)instanceId, (Object)registrationTime, (Object)this.txStartTime);
        this.modifyConfig.remove(GraphDatabaseConfiguration.REGISTRATION_TIME, instanceId);
    }

    private void ensureOpen() {
        Preconditions.checkState((boolean)this.isOpen, (Object)"This management system instance has been closed");
    }

    @Override
    public synchronized void commit() {
        this.ensureOpen();
        if (this.transactionalConfig.hasMutations()) {
            DataOutput out = this.graph.getDataSerializer().getDataOutput(128);
            out.writeObjectNotNull((Object)MgmtLogType.CONFIG_MUTATION);
            this.transactionalConfig.logMutations(out);
            this.sysLog.add(out.getStaticBuffer());
        }
        this.transactionalConfig.commit();
        this.transaction.commit();
        if (!this.updatedTypes.isEmpty() || this.evictGraphFromCache) {
            this.managementLogger.sendCacheEviction(this.updatedTypes, this.evictGraphFromCache, this.updatedTypeTriggers, this.getOpenInstancesInternal());
            for (JanusGraphSchemaVertex schemaVertex : this.updatedTypes) {
                this.schemaCache.expireSchemaElement(schemaVertex.longId());
                for (JanusGraphTransaction janusGraphTransaction : this.graph.getOpenTransactions()) {
                    janusGraphTransaction.expireSchemaElement(schemaVertex.longId());
                }
            }
        }
        if (this.graphShutdownRequired) {
            this.graph.close();
        }
        this.close();
    }

    @Override
    public synchronized void rollback() {
        this.ensureOpen();
        this.transactionalConfig.rollback();
        this.transaction.rollback();
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    private void close() {
        this.isOpen = false;
    }

    public StandardJanusGraphTx getWrappedTx() {
        return this.transaction;
    }

    private JanusGraphEdge addSchemaEdge(JanusGraphVertex out, JanusGraphVertex in, TypeDefinitionCategory def, Object modifier) {
        return this.transaction.addSchemaEdge(out, in, def, modifier);
    }

    public JanusGraphSchemaElement getSchemaElement(long id) {
        JanusGraphSchemaVertex sv;
        JanusGraphVertex v = this.transaction.getVertex(id);
        if (v == null) {
            return null;
        }
        if (v instanceof RelationType) {
            if (((InternalRelationType)v).getBaseType() == null) {
                return (RelationType)v;
            }
            return new RelationTypeIndexWrapper((InternalRelationType)v);
        }
        if (v instanceof JanusGraphSchemaVertex && (sv = (JanusGraphSchemaVertex)v).getDefinition().containsKey((Object)TypeDefinitionCategory.INTERNAL_INDEX)) {
            return new JanusGraphIndexWrapper(sv.asIndexType());
        }
        throw new IllegalArgumentException("Not a valid schema element vertex: " + id);
    }

    @Override
    public RelationTypeIndex buildEdgeIndex(EdgeLabel label, String name, Direction direction, PropertyKey ... sortKeys) {
        return this.buildRelationTypeIndex(label, name, direction, Order.ASC, sortKeys);
    }

    @Override
    public RelationTypeIndex buildEdgeIndex(EdgeLabel label, String name, Direction direction, org.apache.tinkerpop.gremlin.process.traversal.Order sortOrder, PropertyKey ... sortKeys) {
        return this.buildRelationTypeIndex(label, name, direction, Order.convert(sortOrder), sortKeys);
    }

    @Override
    public RelationTypeIndex buildPropertyIndex(PropertyKey key, String name, PropertyKey ... sortKeys) {
        return this.buildRelationTypeIndex(key, name, Direction.OUT, Order.ASC, sortKeys);
    }

    @Override
    public RelationTypeIndex buildPropertyIndex(PropertyKey key, String name, org.apache.tinkerpop.gremlin.process.traversal.Order sortOrder, PropertyKey ... sortKeys) {
        return this.buildRelationTypeIndex(key, name, Direction.OUT, Order.convert(sortOrder), sortKeys);
    }

    private RelationTypeIndex buildRelationTypeIndex(RelationType type, String name, Direction direction, Order sortOrder, PropertyKey ... sortKeys) {
        StandardRelationTypeMaker maker;
        StandardRelationTypeMaker lm;
        Preconditions.checkArgument((type != null && direction != null && sortOrder != null && sortKeys != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Name cannot be blank: %s", (Object)name);
        Token.verifyName(name);
        Preconditions.checkArgument((sortKeys.length > 0 ? 1 : 0) != 0, (Object)"Need to specify sort keys");
        for (PropertyKey key : sortKeys) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Keys cannot be null");
        }
        Preconditions.checkArgument((!(type instanceof EdgeLabel) || !((EdgeLabel)type).isUnidirected() || direction == Direction.OUT ? 1 : 0) != 0, (String)"Can only index uni-directed labels in the out-direction: %s", (Object)type);
        Preconditions.checkArgument((!((InternalRelationType)type).multiplicity().isUnique(direction) ? 1 : 0) != 0, (String)"The relation type [%s] has a multiplicity or cardinality constraint in direction [%s] and can therefore not be indexed", (Object)type, (Object)direction);
        String composedName = ManagementSystem.composeRelationTypeIndexName(type, name);
        if (type.isEdgeLabel()) {
            lm = (StandardEdgeLabelMaker)this.transaction.makeEdgeLabel(composedName);
            ((StandardEdgeLabelMaker)lm).unidirected(direction);
            maker = lm;
        } else {
            assert (type.isPropertyKey());
            assert (direction == Direction.OUT);
            lm = (StandardPropertyKeyMaker)this.transaction.makePropertyKey(composedName);
            ((StandardPropertyKeyMaker)lm).dataType((Class)((PropertyKey)type).dataType());
            maker = lm;
        }
        boolean canIndexBeEnabled = type.isNew() || Arrays.stream(sortKeys).anyMatch(JanusGraphElement::isNew);
        maker.status(canIndexBeEnabled ? SchemaStatus.ENABLED : SchemaStatus.INSTALLED);
        maker.invisible();
        maker.multiplicity(Multiplicity.MULTI);
        maker.sortKey(sortKeys);
        maker.sortOrder(sortOrder);
        long[] typeSig = ((InternalRelationType)type).getSignature();
        HashSet<PropertyKey> signature = new HashSet<PropertyKey>(typeSig.length);
        for (long typeId : typeSig) {
            signature.add(this.transaction.getExistingPropertyKey(typeId));
        }
        for (PropertyKey sortType : sortKeys) {
            signature.remove(sortType);
        }
        if (!signature.isEmpty()) {
            PropertyKey[] propertyKeyArray = signature.toArray(new PropertyKey[signature.size()]);
            maker.signature(propertyKeyArray);
        }
        RelationType relationType = maker.make();
        this.addSchemaEdge(type, relationType, TypeDefinitionCategory.RELATIONTYPE_INDEX, null);
        RelationTypeIndexWrapper index = new RelationTypeIndexWrapper((InternalRelationType)relationType);
        if (!canIndexBeEnabled) {
            this.updateIndex(index, SchemaAction.REGISTER_INDEX);
        }
        return index;
    }

    private static String composeRelationTypeIndexName(RelationType type, String name) {
        return String.valueOf(type.id()) + ':' + name;
    }

    @Override
    public boolean containsRelationIndex(RelationType type, String name) {
        return this.getRelationIndex(type, name) != null;
    }

    @Override
    public RelationTypeIndex getRelationIndex(RelationType type, String name) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name));
        String composedName = ManagementSystem.composeRelationTypeIndexName(type, name);
        JanusGraphVertex v = (JanusGraphVertex)Iterables.getOnlyElement(QueryUtil.getVertices(this.transaction, BaseKey.SchemaName, (Object)JanusGraphSchemaCategory.getRelationTypeName(composedName)), null);
        if (v == null) {
            return null;
        }
        assert (v instanceof InternalRelationType);
        return new RelationTypeIndexWrapper((InternalRelationType)v);
    }

    @Override
    public Iterable<RelationTypeIndex> getRelationIndexes(RelationType type) {
        Preconditions.checkArgument((boolean)(type instanceof InternalRelationType), (String)"Invalid relation type provided: %s", (Object)type);
        return Iterables.transform((Iterable)Iterables.filter(((InternalRelationType)type).getRelationIndexes(), internalRelationType -> !type.equals(internalRelationType)), internalType -> new RelationTypeIndexWrapper((InternalRelationType)internalType));
    }

    public static IndexType getGraphIndexDirect(String name, StandardJanusGraphTx transaction) {
        JanusGraphSchemaVertex v = transaction.getSchemaVertex(JanusGraphSchemaCategory.GRAPHINDEX.getSchemaName(name));
        if (v == null) {
            return null;
        }
        return v.asIndexType();
    }

    @Override
    public boolean containsGraphIndex(String name) {
        return this.getGraphIndex(name) != null;
    }

    @Override
    public JanusGraphIndex getGraphIndex(String name) {
        IndexType index = ManagementSystem.getGraphIndexDirect(name, this.transaction);
        return index == null ? null : new JanusGraphIndexWrapper(index);
    }

    @Override
    public Iterable<JanusGraphIndex> getGraphIndexes(Class<? extends Element> elementType) {
        return IterablesUtil.stream(QueryUtil.getVertices(this.transaction, BaseKey.SchemaCategory, (Object)JanusGraphSchemaCategory.GRAPHINDEX)).map(janusGraphVertex -> {
            assert (janusGraphVertex instanceof JanusGraphSchemaVertex);
            return ((JanusGraphSchemaVertex)janusGraphVertex).asIndexType();
        }).filter(indexType -> indexType.getElement().subsumedBy(elementType)).map(JanusGraphIndexWrapper::new).collect(Collectors.toList());
    }

    @Override
    public JanusGraphSchemaType getIndexOnlyConstraint(String indexName) {
        IndexType index = ManagementSystem.getGraphIndexDirect(indexName, this.transaction);
        if (index == null) {
            throw new IllegalArgumentException("There is no index with name: " + indexName);
        }
        return index.getSchemaTypeConstraint();
    }

    @Override
    public String printSchema() {
        return this.printVertexLabels(false) + this.printEdgeLabels(false) + this.printPropertyKeys(false) + this.printIndexes(false);
    }

    @Override
    public String printVertexLabels() {
        return this.printVertexLabels(true);
    }

    private String printVertexLabels(boolean calledDirectly) {
        StringBuilder sb = new StringBuilder();
        String pattern = "%-30s | %-11s | %-50s |%n";
        Iterable<VertexLabel> labels = this.getVertexLabels();
        boolean hasResults = false;
        sb.append(FIRSTDASH);
        sb.append(String.format(pattern, "Vertex Label Name", "Partitioned", "Static"));
        sb.append(DASHBREAK);
        for (VertexLabel label : labels) {
            hasResults = true;
            sb.append(String.format(pattern, label.name(), label.isPartitioned(), label.isStatic()));
        }
        if (hasResults && calledDirectly) {
            sb.append(DASHBREAK);
        }
        return sb.toString();
    }

    @Override
    public String printEdgeLabels() {
        return this.printEdgeLabels(true);
    }

    private String printEdgeLabels(boolean calledDirectly) {
        StringBuilder sb = new StringBuilder();
        String pattern = "%-30s | %-11s | %-11s | %-36s |%n";
        Iterable<EdgeLabel> labels = this.getRelationTypes(EdgeLabel.class);
        boolean hasResults = false;
        if (calledDirectly) {
            sb.append(FIRSTDASH);
        } else {
            sb.append(DASHBREAK);
        }
        sb.append(String.format(pattern, "Edge Label Name", "Directed", "Unidirected", "Multiplicity"));
        sb.append(DASHBREAK);
        for (EdgeLabel label : labels) {
            hasResults = true;
            sb.append(String.format(pattern, new Object[]{label.name(), label.isDirected(), label.isUnidirected(), label.multiplicity()}));
        }
        if (hasResults && calledDirectly) {
            sb.append(DASHBREAK);
        }
        return sb.toString();
    }

    @Override
    public String printPropertyKeys() {
        return this.printPropertyKeys(true);
    }

    private String printPropertyKeys(boolean calledDirectly) {
        StringBuilder sb = new StringBuilder();
        String pattern = "%-30s | %-11s | %-50s |\n";
        Iterable<PropertyKey> keys = this.getRelationTypes(PropertyKey.class);
        boolean hasResults = false;
        if (calledDirectly) {
            sb.append(FIRSTDASH);
        } else {
            sb.append(DASHBREAK);
        }
        sb.append(String.format(pattern, "Property Key Name", "Cardinality", "Data Type"));
        sb.append(DASHBREAK);
        for (PropertyKey key : keys) {
            hasResults = true;
            sb.append(String.format(pattern, new Object[]{key.name(), key.cardinality(), key.dataType()}));
        }
        if (hasResults && calledDirectly) {
            sb.append(DASHBREAK);
        }
        return sb.toString();
    }

    @Override
    public String printIndexes() {
        return this.printIndexes(true);
    }

    @Override
    public Object getVertexId(String hexString) throws DecoderException {
        return this.graph.getIDManager().getKeyID(StaticArrayBuffer.of(Hex.decodeHex((String)hexString)));
    }

    @Override
    public String getVertexKey(Object vertexId) {
        return Hex.encodeHexString((ByteBuffer)this.graph.getIDManager().getKey(vertexId).asByteBuffer());
    }

    @Override
    public String getIndexKey(String indexName, Map<String, Object> fieldValues) {
        StaticBuffer staticBuffer = this.transaction.getCompositeIndexKey(indexName, fieldValues);
        return Hex.encodeHexString((ByteBuffer)staticBuffer.asByteBuffer());
    }

    @Override
    public CompositeIndexInfo getIndexInfo(String hexString) throws DecoderException {
        StaticArrayBuffer indexKey = StaticArrayBuffer.of(Hex.decodeHex((String)hexString));
        return this.transaction.getCompositeIndexInfo(indexKey);
    }

    private String printIndexes(boolean calledDirectly) {
        StringBuilder sb = new StringBuilder();
        String pattern = "%-30s | %-11s | %-9s | %-14s | %-10s %10s |%n";
        String relationPattern = "%-30s | %-11s | %-9s | %-14s | %-8s | %10s |%n";
        Iterable<JanusGraphIndex> vertexIndexes = this.getGraphIndexes(Vertex.class);
        Iterable<JanusGraphIndex> edgeIndexes = this.getGraphIndexes(Edge.class);
        Iterable<RelationType> relationTypes = this.getRelationTypes(RelationType.class);
        LinkedList relationIndexes = new LinkedList();
        for (RelationType rt : relationTypes) {
            Iterable<RelationTypeIndex> rti = this.getRelationIndexes(rt);
            rti.forEach(relationIndexes::add);
        }
        if (calledDirectly) {
            sb.append(FIRSTDASH);
        } else {
            sb.append(DASHBREAK);
        }
        sb.append(String.format(pattern, "Graph Index (Vertex)", "Type", "Unique", "Backing", "Key:", "Status"));
        sb.append(DASHBREAK);
        sb.append(this.iterateIndexes(pattern, vertexIndexes));
        sb.append(DASHBREAK);
        sb.append(String.format(pattern, "Graph Index (Edge)", "Type", "Unique", "Backing", "Key:", "Status"));
        sb.append(DASHBREAK);
        sb.append(this.iterateIndexes(pattern, edgeIndexes));
        sb.append(DASHBREAK);
        sb.append(String.format(relationPattern, "Relation Index (VCI)", "Type", "Direction", "Sort Key", "Order", "Status"));
        sb.append(DASHBREAK);
        for (RelationTypeIndex ri : relationIndexes) {
            sb.append(String.format(relationPattern, ri.name(), ri.getType(), ri.getDirection(), ri.getSortKey()[0], ri.getSortOrder(), ri.getIndexStatus().name()));
        }
        if (!relationIndexes.isEmpty()) {
            sb.append(DASHBREAK);
        }
        return sb.toString();
    }

    public List<JanusGraphIndex> getGraphIndices(SchemaStatus withoutStatusFilter) {
        List<JanusGraphIndex> indices = this.filter(this.getGraphIndexes(Vertex.class), withoutStatusFilter);
        indices.addAll(this.filter(this.getGraphIndexes(Edge.class), withoutStatusFilter));
        return indices;
    }

    private List<JanusGraphIndex> filter(Iterable<JanusGraphIndex> graphIndices, SchemaStatus withoutStatusFilter) {
        ArrayList<JanusGraphIndex> indicesWithStatus = new ArrayList<JanusGraphIndex>();
        block0: for (JanusGraphIndex graphIndex : graphIndices) {
            for (PropertyKey propertyKey : graphIndex.getFieldKeys()) {
                if (withoutStatusFilter.equals((Object)graphIndex.getIndexStatus(propertyKey))) continue;
                indicesWithStatus.add(graphIndex);
                continue block0;
            }
        }
        return indicesWithStatus;
    }

    public List<RelationTypeIndex> getVertexCentricIndices(SchemaStatus withoutStatusFilter) {
        Iterable<RelationType> relationTypes = this.getRelationTypes(RelationType.class);
        LinkedList<RelationTypeIndex> relationIndexes = new LinkedList<RelationTypeIndex>();
        for (RelationType rt : relationTypes) {
            Iterable<RelationTypeIndex> rti = this.getRelationIndexes(rt);
            rti.forEach(relationTypeIndex -> {
                if (!withoutStatusFilter.equals((Object)relationTypeIndex.getIndexStatus())) {
                    relationIndexes.add((RelationTypeIndex)relationTypeIndex);
                }
            });
        }
        return relationIndexes;
    }

    private String iterateIndexes(String pattern, Iterable<JanusGraphIndex> indexes) {
        StringBuilder sb = new StringBuilder();
        for (JanusGraphIndex index : indexes) {
            String type = this.getIndexType(index);
            PropertyKey[] keys = index.getFieldKeys();
            String[][] keyStatus = this.getKeyStatus(keys, index);
            sb.append(String.format(pattern, index.name(), type, index.isUnique(), index.getBackingIndex(), keyStatus[0][0] + ":", keyStatus[0][1]));
            if (keyStatus.length <= 1) continue;
            for (int i = 1; i < keyStatus.length; ++i) {
                sb.append(String.format(pattern, "", "", "", "", keyStatus[i][0] + ":", keyStatus[i][1]));
            }
        }
        return sb.toString();
    }

    private String[][] getKeyStatus(PropertyKey[] keys, JanusGraphIndex index) {
        String[][] stringArray;
        String[][] keyStatus = new String[keys.length][2];
        for (int i = 0; i < keys.length; ++i) {
            keyStatus[i][0] = keys[i].name();
            keyStatus[i][1] = index.getIndexStatus(keys[i]).name();
        }
        if (keyStatus.length > 0) {
            stringArray = keyStatus;
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"", ""};
        }
        return stringArray;
    }

    private String getIndexType(JanusGraphIndex index) {
        String type = index.isCompositeIndex() ? "Composite" : (index.isMixedIndex() ? "Mixed" : "Unknown");
        return type;
    }

    public static GraphIndexStatusWatcher awaitGraphIndexStatus(JanusGraph g, String graphIndexName) {
        return new GraphIndexStatusWatcher(g, graphIndexName);
    }

    public static RelationIndexStatusWatcher awaitRelationIndexStatus(JanusGraph g, String relationIndexName, String relationTypeName) {
        return new RelationIndexStatusWatcher(g, relationIndexName, relationTypeName);
    }

    private void checkIndexName(String indexName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)indexName));
        Preconditions.checkArgument((this.getGraphIndex(indexName) == null ? 1 : 0) != 0, (String)"An index with name '%s' has already been defined", (Object)indexName);
    }

    private JanusGraphIndex createMixedIndex(String indexName, ElementCategory elementCategory, JanusGraphSchemaType constraint, String backingIndex) {
        Preconditions.checkArgument((boolean)this.graph.getIndexSerializer().containsIndex(backingIndex), (String)"Unknown external index backend: %s", (Object)backingIndex);
        this.checkIndexName(indexName);
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INTERNAL_INDEX, false);
        def.setValue(TypeDefinitionCategory.ELEMENT_CATEGORY, (Object)elementCategory);
        def.setValue(TypeDefinitionCategory.BACKING_INDEX, backingIndex);
        def.setValue(TypeDefinitionCategory.INDEXSTORE_NAME, indexName);
        def.setValue(TypeDefinitionCategory.INDEX_CARDINALITY, (Object)Cardinality.LIST);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)SchemaStatus.ENABLED);
        JanusGraphSchemaVertex indexVertex = this.transaction.makeSchemaVertex(JanusGraphSchemaCategory.GRAPHINDEX, indexName, def);
        Preconditions.checkArgument((constraint == null || elementCategory.isValidConstraint(constraint) && constraint instanceof JanusGraphSchemaVertex ? 1 : 0) != 0);
        if (constraint != null) {
            this.addSchemaEdge(indexVertex, (JanusGraphSchemaVertex)((Object)constraint), TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, null);
        }
        this.updateSchemaVertex(indexVertex);
        return new JanusGraphIndexWrapper(indexVertex.asIndexType());
    }

    @Override
    public void addIndexKey(JanusGraphIndex index, PropertyKey key, Parameter ... parameters) {
        Preconditions.checkArgument((index != null && key != null && index instanceof JanusGraphIndexWrapper && !(key instanceof BaseKey) ? 1 : 0) != 0, (Object)"Need to provide valid index and key");
        if (parameters == null) {
            parameters = new Parameter[]{};
        }
        IndexType indexType = ((JanusGraphIndexWrapper)index).getBaseIndex();
        Preconditions.checkArgument((boolean)(indexType instanceof MixedIndexType), (String)"Can only add keys to an external index, not %s", (Object)index.name());
        Preconditions.checkArgument((indexType instanceof IndexTypeWrapper && key instanceof JanusGraphSchemaVertex && ((IndexTypeWrapper)indexType).getSchemaBase() instanceof JanusGraphSchemaVertex ? 1 : 0) != 0);
        JanusGraphSchemaVertex indexVertex = (JanusGraphSchemaVertex)((IndexTypeWrapper)indexType).getSchemaBase();
        for (IndexField field : indexType.getFieldKeys()) {
            Preconditions.checkArgument((!field.getFieldKey().equals(key) ? 1 : 0) != 0, (String)"Key [%s] has already been added to index %s", (Object)key.name(), (Object)index.name());
        }
        boolean addMappingParameter = !ParameterType.MAPPED_NAME.hasParameter(parameters);
        Parameter[] extendedParas = new Parameter[parameters.length + 1 + (addMappingParameter ? 1 : 0)];
        System.arraycopy(parameters, 0, extendedParas, 0, parameters.length);
        int arrPosition = parameters.length;
        if (addMappingParameter) {
            extendedParas[arrPosition++] = ParameterType.MAPPED_NAME.getParameter(this.graph.getIndexSerializer().getDefaultFieldName(key, parameters, indexType.getBackingIndexName()));
        }
        extendedParas[arrPosition] = ParameterType.STATUS.getParameter(key.isNew() ? SchemaStatus.ENABLED : SchemaStatus.INSTALLED);
        this.addSchemaEdge(indexVertex, key, TypeDefinitionCategory.INDEX_FIELD, extendedParas);
        this.updateSchemaVertex(indexVertex);
        indexType.resetCache();
        if (!this.graph.getIndexSerializer().supports((MixedIndexType)indexType, ParameterIndexField.of(key, parameters))) {
            throw new JanusGraphException("Could not register new index field '" + key.name() + "' with index backend as the data type, cardinality or parameter combination is not supported.");
        }
        try {
            IndexSerializer.register((MixedIndexType)indexType, key, this.transaction.getTxHandle());
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not register new index field with index backend", e);
        }
        if (!indexVertex.isNew()) {
            this.updatedTypes.add(indexVertex);
        }
        if (!key.isNew()) {
            this.updateIndex(index, SchemaAction.REGISTER_INDEX);
        }
    }

    @Override
    public void addInlinePropertyKey(JanusGraphIndex index, PropertyKey key) {
        Preconditions.checkArgument((index != null && key != null && index instanceof JanusGraphIndexWrapper && !(key instanceof BaseKey) ? 1 : 0) != 0, (Object)"Need to provide valid index and key");
        IndexType indexType = ((JanusGraphIndexWrapper)index).getBaseIndex();
        Preconditions.checkArgument((boolean)(indexType instanceof CompositeIndexType), (String)"Can only add keys to a composite index, not %s", (Object)index.name());
        Preconditions.checkArgument((indexType instanceof IndexTypeWrapper && key instanceof JanusGraphSchemaVertex && ((IndexTypeWrapper)indexType).getSchemaBase() instanceof JanusGraphSchemaVertex ? 1 : 0) != 0);
        JanusGraphSchemaVertex indexVertex = (JanusGraphSchemaVertex)((IndexTypeWrapper)indexType).getSchemaBase();
        for (IndexField field : indexType.getFieldKeys()) {
            Preconditions.checkArgument((!field.getFieldKey().equals(key) ? 1 : 0) != 0, (String)"Key [%s] has already been added to index %s", (Object)key.name(), (Object)index.name());
        }
        this.addSchemaEdge(indexVertex, key, TypeDefinitionCategory.INDEX_INLINE_KEY, null);
        this.updateSchemaVertex(indexVertex);
        indexType.resetCache();
        if (!indexVertex.isNew()) {
            this.updatedTypes.add(indexVertex);
        }
    }

    private JanusGraphIndex createCompositeIndex(String indexName, ElementCategory elementCategory, boolean unique, JanusGraphSchemaType constraint, Set<PropertyKey> inlineProps, PropertyKey ... keys) {
        this.checkIndexName(indexName);
        Preconditions.checkArgument((keys != null && keys.length > 0 ? 1 : 0) != 0, (String)"Need to provide keys to index [%s]", (Object)indexName);
        Preconditions.checkArgument((!unique || elementCategory == ElementCategory.VERTEX ? 1 : 0) != 0, (String)"Unique indexes can only be created on vertices [%s]", (Object)indexName);
        boolean allSingleKeys = true;
        boolean oneNewKey = false;
        for (PropertyKey key : keys) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Need to provide valid keys: %s", (Object)key);
            if (key.cardinality() != Cardinality.SINGLE) {
                allSingleKeys = false;
            }
            if (key.isNew()) {
                oneNewKey = true;
                continue;
            }
            this.updatedTypes.add((PropertyKeyVertex)key);
        }
        Cardinality indexCardinality = unique ? Cardinality.SINGLE : (allSingleKeys ? Cardinality.SET : Cardinality.LIST);
        boolean canIndexBeEnabled = oneNewKey || constraint != null && constraint.isNew();
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INTERNAL_INDEX, true);
        def.setValue(TypeDefinitionCategory.ELEMENT_CATEGORY, (Object)elementCategory);
        def.setValue(TypeDefinitionCategory.BACKING_INDEX, "internalindex");
        def.setValue(TypeDefinitionCategory.INDEXSTORE_NAME, indexName);
        def.setValue(TypeDefinitionCategory.INDEX_CARDINALITY, (Object)indexCardinality);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)(canIndexBeEnabled ? SchemaStatus.ENABLED : SchemaStatus.INSTALLED));
        JanusGraphSchemaVertex indexVertex = this.transaction.makeSchemaVertex(JanusGraphSchemaCategory.GRAPHINDEX, indexName, def);
        for (int i = 0; i < keys.length; ++i) {
            Parameter[] paras = new Parameter[]{ParameterType.INDEX_POSITION.getParameter(i)};
            this.addSchemaEdge(indexVertex, keys[i], TypeDefinitionCategory.INDEX_FIELD, paras);
        }
        for (PropertyKey propertyKey : inlineProps) {
            this.addSchemaEdge(indexVertex, propertyKey, TypeDefinitionCategory.INDEX_INLINE_KEY, null);
        }
        Preconditions.checkArgument((constraint == null || elementCategory.isValidConstraint(constraint) && constraint instanceof JanusGraphSchemaVertex ? 1 : 0) != 0);
        if (constraint != null) {
            this.addSchemaEdge(indexVertex, (JanusGraphSchemaVertex)((Object)constraint), TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, null);
        }
        this.updateSchemaVertex(indexVertex);
        JanusGraphIndexWrapper index = new JanusGraphIndexWrapper(indexVertex.asIndexType());
        if (!canIndexBeEnabled) {
            this.updateIndex(index, SchemaAction.REGISTER_INDEX);
        }
        return index;
    }

    @Override
    public JanusGraphManagement.IndexBuilder buildIndex(String indexName, Class<? extends Element> elementType) {
        return new IndexBuilder(indexName, ElementCategory.getByClazz(elementType));
    }

    @Override
    public ScanJobFuture updateIndex(Index index, SchemaAction updateAction) {
        return this.updateIndex(index, updateAction, null, Runtime.getRuntime().availableProcessors());
    }

    @Override
    public ScanJobFuture updateIndex(Index index, SchemaAction updateAction, int numOfThreads) {
        return this.updateIndex(index, updateAction, null, numOfThreads);
    }

    @Override
    public ScanJobFuture updateIndex(Index index, SchemaAction updateAction, List<Object> vertexOnly) {
        return this.updateIndex(index, updateAction, vertexOnly, Runtime.getRuntime().availableProcessors());
    }

    private ScanJobFuture updateIndex(Index index, SchemaAction updateAction, List<Object> vertexOnly, int numOfThreads) {
        ScanJobFuture future;
        Set<JanusGraphSchemaVertex> dependentTypes;
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"Need to provide an index");
        Preconditions.checkArgument((updateAction != null ? 1 : 0) != 0, (Object)"Need to provide update action");
        JanusGraphSchemaVertex schemaVertex = this.getSchemaVertex(index);
        Set<PropertyKeyVertex> keySubset = Collections.emptySet();
        if (index instanceof RelationTypeIndex) {
            dependentTypes = Collections.singleton((JanusGraphSchemaVertex)((Object)((InternalRelationType)((Object)schemaVertex)).getBaseType()));
            if (!updateAction.isApplicableStatus(schemaVertex.getStatus())) {
                return null;
            }
        } else if (index instanceof JanusGraphIndex) {
            IndexType indexType = schemaVertex.asIndexType();
            dependentTypes = new HashSet<JanusGraphSchemaVertex>();
            if (indexType.isCompositeIndex()) {
                if (!updateAction.isApplicableStatus(schemaVertex.getStatus())) {
                    return null;
                }
                for (PropertyKey key : ((JanusGraphIndex)index).getFieldKeys()) {
                    dependentTypes.add((PropertyKeyVertex)key);
                }
            } else {
                keySubset = new HashSet();
                MixedIndexType mixedIndexType = (MixedIndexType)indexType;
                Set<SchemaStatus> applicableStatus = updateAction.getApplicableStatus();
                for (ParameterIndexField field : mixedIndexType.getFieldKeys()) {
                    if (!applicableStatus.contains((Object)field.getStatus())) continue;
                    keySubset.add((PropertyKeyVertex)field.getFieldKey());
                }
                dependentTypes.addAll(keySubset);
            }
        } else {
            throw new UnsupportedOperationException("Updates not supported for index: " + index);
        }
        IndexIdentifier indexId = new IndexIdentifier(index);
        switch (updateAction) {
            case REGISTER_INDEX: {
                this.setStatus(schemaVertex, SchemaStatus.INSTALLED, keySubset);
                this.updatedTypes.add(schemaVertex);
                this.updatedTypes.addAll(dependentTypes);
                this.setUpdateTrigger(new UpdateStatusTrigger(this.graph, schemaVertex, SchemaStatus.REGISTERED, keySubset));
                future = new EmptyScanJobFuture();
                break;
            }
            case REINDEX: {
                StandardScanner.Builder builder = this.graph.getBackend().buildEdgeScanJob();
                builder.setFinishJob(indexId.getIndexJobFinisher(this.graph, SchemaAction.ENABLE_INDEX));
                builder.setJobId(indexId);
                builder.setNumProcessingThreads(numOfThreads);
                builder.setJob(VertexJobConverter.convert(this.graph, new IndexRepairJob(indexId.indexName, indexId.relationTypeName), vertexOnly));
                try {
                    future = builder.execute();
                    break;
                }
                catch (BackendException e) {
                    throw new JanusGraphException(e);
                }
            }
            case ENABLE_INDEX: {
                this.setStatus(schemaVertex, SchemaStatus.ENABLED, keySubset);
                this.updatedTypes.add(schemaVertex);
                if (!keySubset.isEmpty()) {
                    this.updatedTypes.addAll(dependentTypes);
                }
                future = new EmptyScanJobFuture();
                break;
            }
            case DISABLE_INDEX: {
                this.setStatus(schemaVertex, SchemaStatus.DISABLED, keySubset);
                this.updatedTypes.add(schemaVertex);
                if (!keySubset.isEmpty()) {
                    this.updatedTypes.addAll(dependentTypes);
                }
                future = new EmptyScanJobFuture();
                break;
            }
            case MARK_DISCARDED: {
                this.setStatus(schemaVertex, SchemaStatus.DISCARDED, keySubset);
                this.updatedTypes.add(schemaVertex);
                if (!keySubset.isEmpty()) {
                    this.updatedTypes.addAll(dependentTypes);
                }
                future = new EmptyScanJobFuture();
                break;
            }
            case DISCARD_INDEX: {
                StandardScanner.Builder builder;
                if (index instanceof JanusGraphIndex && ((JanusGraphIndex)index).isMixedIndex()) {
                    try {
                        JanusGraphIndexWrapper indexWrapper = (JanusGraphIndexWrapper)index;
                        MixedIndexType mixedIndex = (MixedIndexType)indexWrapper.getBaseIndex();
                        IndexSerializer.clearStore(mixedIndex, this.transaction.getTxHandle());
                        this.setStatus(schemaVertex, SchemaStatus.DISCARDED, keySubset);
                        this.updatedTypes.add(schemaVertex);
                        if (!keySubset.isEmpty()) {
                            this.updatedTypes.addAll(dependentTypes);
                        }
                    }
                    catch (BackendException ex) {
                        throw new UnsupportedOperationException("Index removal is not supported for this Backend. Index must be removed in the indexing system directly.", ex);
                    }
                    future = new EmptyScanJobFuture();
                    break;
                }
                if (index instanceof JanusGraphIndex && ((JanusGraphIndex)index).isCompositeIndex()) {
                    builder = this.graph.getBackend().buildGraphIndexScanJob();
                } else if (index instanceof RelationTypeIndex) {
                    builder = this.graph.getBackend().buildEdgeScanJob();
                } else {
                    throw new IllegalArgumentException("Unsupported Index Type");
                }
                builder.setFinishJob(indexId.getIndexJobFinisher(this.graph, SchemaAction.MARK_DISCARDED));
                builder.setJobId(indexId);
                builder.setNumProcessingThreads(numOfThreads);
                builder.setJob(new IndexRemoveJob(this.graph, indexId.indexName, indexId.relationTypeName));
                try {
                    future = builder.execute();
                    break;
                }
                catch (BackendException e) {
                    throw new JanusGraphException(e);
                }
            }
            case DROP_INDEX: {
                this.updatedTypes.add(schemaVertex);
                this.updatedTypes.addAll(dependentTypes);
                schemaVertex.remove();
                future = new EmptyScanJobFuture();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Update action not supported: " + (Object)((Object)updateAction));
            }
        }
        return future;
    }

    public void evictGraphFromCache() {
        this.evictGraphFromCache(null);
    }

    public void evictGraphFromCache(Callable<Boolean> trigger) {
        this.evictGraphFromCache = true;
        if (trigger != null) {
            this.setUpdateTrigger(trigger);
        } else {
            this.setUpdateTrigger(new GraphCacheEvictionCompleteTrigger(this.graph.getGraphName()));
        }
    }

    private void setUpdateTrigger(Callable<Boolean> trigger) {
        this.updatedTypeTriggers.add(trigger);
    }

    private void setStatus(JanusGraphSchemaVertex vertex, SchemaStatus status, Set<PropertyKeyVertex> keys) {
        if (keys.isEmpty()) {
            this.setStatusVertex(vertex, status);
        } else {
            this.setStatusEdges(vertex, status, keys);
        }
        vertex.resetCache();
        this.updateSchemaVertex(vertex);
    }

    private void setStatusVertex(JanusGraphSchemaVertex vertex, SchemaStatus status) {
        Preconditions.checkArgument((vertex instanceof RelationTypeVertex || vertex.asIndexType().isCompositeIndex() ? 1 : 0) != 0);
        for (JanusGraphVertexProperty p : ((VertexCentricQueryBuilder)vertex.query().types(BaseKey.SchemaDefinitionProperty)).properties()) {
            if (((TypeDefinitionDescription)p.valueOrNull(BaseKey.SchemaDefinitionDesc)).getCategory() != TypeDefinitionCategory.STATUS) continue;
            if (p.value().equals((Object)status)) {
                return;
            }
            p.remove();
        }
        JanusGraphVertexProperty p = this.transaction.addProperty(vertex, BaseKey.SchemaDefinitionProperty, (Object)status);
        p.property(BaseKey.SchemaDefinitionDesc.name(), TypeDefinitionDescription.of(TypeDefinitionCategory.STATUS));
    }

    private void setStatusEdges(JanusGraphSchemaVertex vertex, SchemaStatus status, Set<PropertyKeyVertex> keys) {
        Preconditions.checkArgument((boolean)vertex.asIndexType().isMixedIndex());
        for (JanusGraphEdge edge : vertex.getEdges(TypeDefinitionCategory.INDEX_FIELD, Direction.OUT)) {
            if (!keys.contains(edge.vertex(Direction.IN))) continue;
            TypeDefinitionDescription desc = (TypeDefinitionDescription)edge.valueOrNull(BaseKey.SchemaDefinitionDesc);
            assert (desc.getCategory() == TypeDefinitionCategory.INDEX_FIELD);
            Parameter[] parameters = (Parameter[])desc.getModifier();
            assert (parameters[parameters.length - 1].key().equals(ParameterType.STATUS.getName()));
            if (parameters[parameters.length - 1].value().equals((Object)status)) continue;
            Parameter[] paraCopy = Arrays.copyOf(parameters, parameters.length);
            paraCopy[parameters.length - 1] = ParameterType.STATUS.getParameter(status);
            edge.remove();
            this.addSchemaEdge(vertex, edge.vertex(Direction.IN), TypeDefinitionCategory.INDEX_FIELD, paraCopy);
        }
        for (PropertyKeyVertex prop : keys) {
            prop.resetCache();
        }
    }

    @Override
    public ScanJobFuture getIndexJobStatus(Index index) {
        IndexIdentifier indexId = new IndexIdentifier(index);
        return this.graph.getBackend().getScanJobStatus(indexId);
    }

    @Override
    public void changeName(JanusGraphSchemaElement element, String newName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)newName), (String)"Invalid name: %s", (Object)newName);
        JanusGraphSchemaVertex schemaVertex = this.getSchemaVertex(element);
        String oldName = schemaVertex.name();
        if (oldName.equals(newName)) {
            return;
        }
        JanusGraphSchemaCategory schemaCategory = (JanusGraphSchemaCategory)((Object)schemaVertex.valueOrNull(BaseKey.SchemaCategory));
        Preconditions.checkArgument((boolean)schemaCategory.hasName(), (String)"Invalid schema element: %s", (Object)element);
        if (schemaVertex instanceof RelationType) {
            InternalRelationType relType = (InternalRelationType)((Object)schemaVertex);
            if (relType.getBaseType() != null) {
                newName = ManagementSystem.composeRelationTypeIndexName(relType.getBaseType(), newName);
            } else assert (!(element instanceof RelationTypeIndex));
            JanusGraphSchemaCategory cat = relType.isEdgeLabel() ? JanusGraphSchemaCategory.EDGELABEL : JanusGraphSchemaCategory.PROPERTYKEY;
            SystemTypeManager.throwIfSystemName(cat, newName);
        } else if (element instanceof VertexLabel) {
            SystemTypeManager.throwIfSystemName(JanusGraphSchemaCategory.VERTEXLABEL, newName);
        } else if (element instanceof JanusGraphIndex) {
            this.checkIndexName(newName);
        }
        this.transaction.addProperty(schemaVertex, BaseKey.SchemaName, schemaCategory.getSchemaName(newName));
        this.updateConnectionEdgeConstraints(schemaVertex, oldName, newName);
        this.updateSchemaVertex(schemaVertex);
        schemaVertex.resetCache();
        this.updatedTypes.add(schemaVertex);
    }

    private void updateConnectionEdgeConstraints(JanusGraphSchemaVertex edgeLabel, String oldName, String newName) {
        if (!(edgeLabel instanceof EdgeLabel)) {
            return;
        }
        ((EdgeLabel)((Object)edgeLabel)).mappedConnections().stream().peek(s -> this.schemaCache.expireSchemaElement(s.getOutgoingVertexLabel().longId())).map(Connection::getConnectionEdge).forEach(edge -> {
            TypeDefinitionDescription desc = new TypeDefinitionDescription(TypeDefinitionCategory.CONNECTION_EDGE, newName);
            edge.property(BaseKey.SchemaDefinitionDesc.name(), desc);
        });
    }

    public JanusGraphSchemaVertex getSchemaVertex(JanusGraphSchemaElement element) {
        if (element instanceof RelationType) {
            Preconditions.checkArgument((boolean)(element instanceof RelationTypeVertex), (String)"Invalid schema element provided: %s", (Object)element);
            return (RelationTypeVertex)element;
        }
        if (element instanceof RelationTypeIndex) {
            return (RelationTypeVertex)((RelationTypeIndexWrapper)element).getWrappedType();
        }
        if (element instanceof VertexLabel) {
            Preconditions.checkArgument((boolean)(element instanceof VertexLabelVertex), (String)"Invalid schema element provided: %s", (Object)element);
            return (VertexLabelVertex)element;
        }
        if (element instanceof JanusGraphIndex) {
            Preconditions.checkArgument((boolean)(element instanceof JanusGraphIndexWrapper), (String)"Invalid schema element provided: %s", (Object)element);
            IndexType index = ((JanusGraphIndexWrapper)element).getBaseIndex();
            assert (index instanceof IndexTypeWrapper);
            SchemaSource base = ((IndexTypeWrapper)index).getSchemaBase();
            assert (base instanceof JanusGraphSchemaVertex);
            return (JanusGraphSchemaVertex)base;
        }
        throw new IllegalArgumentException("Invalid schema element provided: " + element);
    }

    private void updateSchemaVertex(JanusGraphSchemaVertex schemaVertex) {
        this.transaction.updateSchemaVertex(schemaVertex);
    }

    @Override
    public ConsistencyModifier getConsistency(JanusGraphSchemaElement element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0);
        if (element instanceof RelationType) {
            return ((InternalRelationType)element).getConsistencyModifier();
        }
        if (element instanceof JanusGraphIndex) {
            IndexType index = ((JanusGraphIndexWrapper)element).getBaseIndex();
            if (index.isMixedIndex()) {
                return ConsistencyModifier.DEFAULT;
            }
            return ((CompositeIndexType)index).getConsistencyModifier();
        }
        return ConsistencyModifier.DEFAULT;
    }

    @Override
    public void setConsistency(JanusGraphSchemaElement element, ConsistencyModifier consistency) {
        if (element instanceof RelationType) {
            RelationTypeVertex rv = (RelationTypeVertex)element;
            Preconditions.checkArgument((consistency != ConsistencyModifier.FORK || !rv.multiplicity().isConstrained() ? 1 : 0) != 0, (String)"Cannot apply FORK consistency mode to constraint relation type: %s", (Object)rv.name());
        } else if (element instanceof JanusGraphIndex) {
            IndexType index = ((JanusGraphIndexWrapper)element).getBaseIndex();
            if (index.isMixedIndex()) {
                throw new IllegalArgumentException("Cannot change consistency on mixed index: " + element);
            }
        } else {
            throw new IllegalArgumentException("Cannot change consistency of schema element: " + element);
        }
        this.setTypeModifier(element, ModifierType.CONSISTENCY, (Object)consistency);
    }

    @Override
    public Duration getTTL(JanusGraphSchemaType type) {
        int ttl;
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        if (type instanceof VertexLabelVertex) {
            ttl = ((VertexLabelVertex)type).getTTL();
        } else if (type instanceof RelationTypeVertex) {
            ttl = ((RelationTypeVertex)type).getTTL();
        } else {
            throw new IllegalArgumentException("given type does not support TTL: " + type.getClass());
        }
        return Duration.ofSeconds(ttl);
    }

    @Override
    public void setTTL(JanusGraphSchemaType type, Duration duration) {
        if (!this.graph.getBackend().getStoreFeatures().hasCellTTL()) {
            throw new UnsupportedOperationException("The storage engine does not support TTL");
        }
        if (type instanceof VertexLabelVertex) {
            Preconditions.checkArgument((boolean)((VertexLabelVertex)type).isStatic(), (Object)"must define vertex label as static to allow setting TTL");
        } else {
            Preconditions.checkArgument((type instanceof EdgeLabelVertex || type instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"TTL is not supported for type %s", (Object)type.getClass().getSimpleName());
        }
        Preconditions.checkArgument((boolean)(type instanceof JanusGraphSchemaVertex));
        Integer ttlSeconds = duration.isZero() ? null : Integer.valueOf((int)duration.getSeconds());
        this.setTypeModifier(type, ModifierType.TTL, ttlSeconds);
    }

    @Override
    public ScanJobFuture removeGhostVertices(int numOfThreads) {
        ScanJobFuture future;
        StandardScanner.Builder builder = this.graph.getBackend().buildEdgeScanJob();
        builder.setJob(new GhostVertexRemover(this.graph));
        builder.setNumProcessingThreads(numOfThreads);
        try {
            future = builder.execute();
        }
        catch (BackendException e) {
            throw new JanusGraphException(e);
        }
        return future;
    }

    @Override
    public ScanJobFuture removeGhostVertices() {
        return this.removeGhostVertices(Runtime.getRuntime().availableProcessors());
    }

    private void setTypeModifier(JanusGraphSchemaElement element, ModifierType modifierType, Object value) {
        JanusGraphSchemaVertex typeVertex;
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (Object)"null schema element");
        TypeDefinitionCategory cat = modifierType.getCategory();
        if (cat.hasDataType() && null != value) {
            Preconditions.checkArgument((boolean)cat.getDataType().equals(value.getClass()), (String)"modifier value is not of expected type %s", cat.getDataType());
        }
        if (element instanceof JanusGraphSchemaVertex) {
            typeVertex = (JanusGraphSchemaVertex)((Object)element);
        } else if (element instanceof JanusGraphIndex) {
            IndexType index = ((JanusGraphIndexWrapper)element).getBaseIndex();
            assert (index instanceof IndexTypeWrapper);
            SchemaSource base = ((IndexTypeWrapper)index).getSchemaBase();
            typeVertex = (JanusGraphSchemaVertex)base;
        } else {
            throw new IllegalArgumentException("Invalid schema element: " + element);
        }
        for (JanusGraphEdge e : typeVertex.getEdges(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT)) {
            JanusGraphSchemaVertex v = (JanusGraphSchemaVertex)e.vertex(Direction.IN);
            TypeDefinitionMap def = v.getDefinition();
            Object existingValue = def.getValue(modifierType.getCategory());
            if (null == existingValue) continue;
            if (existingValue.equals(value)) {
                return;
            }
            e.remove();
            v.remove();
        }
        if (null != value) {
            TypeDefinitionMap def = new TypeDefinitionMap();
            def.setValue(cat, value);
            JanusGraphSchemaVertex cVertex = this.transaction.makeSchemaVertex(JanusGraphSchemaCategory.TYPE_MODIFIER, null, def);
            this.addSchemaEdge(typeVertex, cVertex, TypeDefinitionCategory.TYPE_MODIFIER, null);
        }
        this.updateSchemaVertex(typeVertex);
        this.updatedTypes.add(typeVertex);
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.transaction.containsRelationType(name);
    }

    @Override
    public RelationType getRelationType(String name) {
        return this.transaction.getRelationType(name);
    }

    @Override
    public boolean containsPropertyKey(String name) {
        return this.transaction.containsPropertyKey(name);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        return this.transaction.getPropertyKey(name);
    }

    @Override
    public boolean containsEdgeLabel(String name) {
        return this.transaction.containsEdgeLabel(name);
    }

    @Override
    public EdgeLabel getOrCreateEdgeLabel(String name) {
        return this.transaction.getOrCreateEdgeLabel(name);
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name) {
        return this.transaction.getOrCreatePropertyKey(name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        return this.transaction.getEdgeLabel(name);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        return this.transaction.makePropertyKey(name);
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        return this.transaction.makeEdgeLabel(name);
    }

    @Override
    public <T extends RelationType> Iterable<T> getRelationTypes(Class<T> clazz) {
        Iterable types;
        Preconditions.checkNotNull(clazz);
        if (PropertyKey.class.equals(clazz)) {
            types = QueryUtil.getVertices(this.transaction, BaseKey.SchemaCategory, (Object)JanusGraphSchemaCategory.PROPERTYKEY);
        } else if (EdgeLabel.class.equals(clazz)) {
            types = QueryUtil.getVertices(this.transaction, BaseKey.SchemaCategory, (Object)JanusGraphSchemaCategory.EDGELABEL);
        } else if (RelationType.class.equals(clazz)) {
            types = Iterables.concat(this.getRelationTypes(EdgeLabel.class), this.getRelationTypes(PropertyKey.class));
        } else {
            throw new IllegalArgumentException("Unknown type class: " + clazz);
        }
        return Iterables.filter((Iterable)Iterables.filter(types, clazz), t -> ((InternalRelationType)t).getBaseType() == null);
    }

    @Override
    public boolean containsVertexLabel(String name) {
        return this.transaction.containsVertexLabel(name);
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        return this.transaction.getVertexLabel(name);
    }

    @Override
    public VertexLabel getOrCreateVertexLabel(String name) {
        return this.transaction.getOrCreateVertexLabel(name);
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        return this.transaction.makeVertexLabel(name);
    }

    @Override
    public VertexLabel addProperties(VertexLabel vertexLabel, PropertyKey ... keys) {
        return this.transaction.addProperties(vertexLabel, keys);
    }

    @Override
    public EdgeLabel addProperties(EdgeLabel edgeLabel, PropertyKey ... keys) {
        return this.transaction.addProperties(edgeLabel, keys);
    }

    @Override
    public EdgeLabel addConnection(EdgeLabel edgeLabel, VertexLabel outVLabel, VertexLabel inVLabel) {
        return this.transaction.addConnection(edgeLabel, outVLabel, inVLabel);
    }

    @Override
    public Iterable<VertexLabel> getVertexLabels() {
        return Iterables.filter(QueryUtil.getVertices(this.transaction, BaseKey.SchemaCategory, (Object)JanusGraphSchemaCategory.VERTEXLABEL), VertexLabel.class);
    }

    @Override
    public synchronized String get(String path) {
        this.ensureOpen();
        return this.userConfig.get(path);
    }

    @Override
    public synchronized JanusGraphConfiguration set(String path, Object value) {
        this.ensureOpen();
        return this.userConfig.set(path, value);
    }

    @Override
    public JanusGraphConfiguration remove(String path) {
        this.ensureOpen();
        return this.userConfig.remove(path);
    }

    private static class IndexIdentifier {
        private final String indexName;
        private final String relationTypeName;
        private final int hashcode;

        private IndexIdentifier(Index index) {
            Preconditions.checkArgument((index != null ? 1 : 0) != 0);
            this.indexName = index.name();
            this.relationTypeName = index instanceof RelationTypeIndex ? ((RelationTypeIndex)index).getType().name() : null;
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.indexName));
            this.hashcode = Objects.hash(this.indexName, this.relationTypeName);
        }

        private Index retrieve(ManagementSystem management) {
            if (this.relationTypeName == null) {
                return management.getGraphIndex(this.indexName);
            }
            return management.getRelationIndex(management.getRelationType(this.relationTypeName), this.indexName);
        }

        public String toString() {
            String s = this.indexName;
            if (this.relationTypeName != null) {
                s = s + "[" + this.relationTypeName + "]";
            }
            return s;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!this.getClass().isInstance(other)) {
                return false;
            }
            IndexIdentifier oth = (IndexIdentifier)other;
            return this.indexName.equals(oth.indexName) && Objects.equals(this.relationTypeName, oth.relationTypeName);
        }

        public Consumer<ScanMetrics> getIndexJobFinisher() {
            return this.getIndexJobFinisher(null, null);
        }

        public Consumer<ScanMetrics> getIndexJobFinisher(JanusGraph graph, SchemaAction action) {
            Preconditions.checkArgument((graph != null && action != null || graph == null && action == null ? 1 : 0) != 0);
            return metrics -> {
                block8: {
                    try {
                        if (metrics.get(ScanMetrics.Metric.FAILURE) == 0L) {
                            if (action != null) {
                                ManagementSystem management = (ManagementSystem)graph.openManagement();
                                try {
                                    Index index = this.retrieve(management);
                                    management.updateIndex(index, action);
                                }
                                finally {
                                    management.commit();
                                }
                            }
                            LOGGER.info("Index update job successful for [{}]", (Object)this);
                            break block8;
                        }
                        LOGGER.error("Index update job unsuccessful for [{}]. Check logs", (Object)this);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Error encountered when updating index after job finished [" + this + "]: ", e);
                    }
                }
            };
        }
    }

    public static class IndexJobStatus
    extends JobStatus {
        private final ScanMetrics metrics;

        public IndexJobStatus(JobStatus.State state, ScanMetrics metrics) {
            super(state, metrics == null ? 0L : metrics.get(ScanMetrics.Metric.SUCCESS));
            this.metrics = metrics;
        }

        public ScanMetrics getMetrics() {
            return this.metrics;
        }

        public String toString() {
            String msg = "Job status: " + this.getState().toString() + ". ";
            if (this.metrics != null) {
                msg = msg + String.format("Processed %s records successfully and failed on %s records.", this.metrics.get(ScanMetrics.Metric.SUCCESS), this.metrics.get(ScanMetrics.Metric.FAILURE));
            }
            return msg;
        }
    }

    private static class UpdateStatusTrigger
    implements Callable<Boolean> {
        private static final Logger log = LoggerFactory.getLogger(UpdateStatusTrigger.class);
        private final StandardJanusGraph graph;
        private final long schemaVertexId;
        private final SchemaStatus newStatus;
        private final Set<Long> propertyKeys;

        private UpdateStatusTrigger(StandardJanusGraph graph, JanusGraphSchemaVertex vertex, SchemaStatus newStatus, Iterable<PropertyKeyVertex> keys) {
            this.graph = graph;
            this.schemaVertexId = vertex.longId();
            this.newStatus = newStatus;
            this.propertyKeys = IterablesUtil.stream(keys).map(JanusGraphSchemaType::longId).collect(Collectors.toSet());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean call() throws Exception {
            ManagementSystem management = (ManagementSystem)this.graph.openManagement();
            try {
                JanusGraphVertex vertex = management.transaction.getVertex(this.schemaVertexId);
                Preconditions.checkArgument((vertex != null && vertex instanceof JanusGraphSchemaVertex ? 1 : 0) != 0);
                JanusGraphSchemaVertex schemaVertex = (JanusGraphSchemaVertex)vertex;
                HashSet<PropertyKeyVertex> keys = new HashSet<PropertyKeyVertex>(this.propertyKeys.size());
                for (Long l : this.propertyKeys) {
                    keys.add((PropertyKeyVertex)management.transaction.getVertex(l));
                }
                management.setStatus(schemaVertex, this.newStatus, keys);
                management.updatedTypes.addAll(keys);
                management.updatedTypes.add(schemaVertex);
                if (log.isInfoEnabled()) {
                    void var6_11;
                    HashSet<String> propNames = new HashSet<String>(keys.size());
                    for (PropertyKeyVertex v : keys) {
                        try {
                            propNames.add(v.name());
                        }
                        catch (Throwable t) {
                            log.warn("Failed to get name for property key with id {}", (Object)v.longId(), (Object)t);
                            propNames.add("(ID#" + v.longId() + ")");
                        }
                    }
                    String string = "(ID#" + this.schemaVertexId + ")";
                    try {
                        String string2 = schemaVertex.name();
                    }
                    catch (Throwable t) {
                        log.warn("Failed to get name for schema vertex with id {}", (Object)this.schemaVertexId, (Object)t);
                    }
                    log.info("Set status {} on schema element {} with property keys {}", new Object[]{this.newStatus, var6_11, propNames});
                }
                management.commit();
                return true;
            }
            catch (RuntimeException e) {
                management.rollback();
                throw e;
            }
        }

        public int hashCode() {
            return Long.hashCode(this.schemaVertexId);
        }

        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null || !this.getClass().isInstance(oth)) {
                return false;
            }
            return this.schemaVertexId == ((UpdateStatusTrigger)oth).schemaVertexId;
        }
    }

    private static class GraphCacheEvictionCompleteTrigger
    implements Callable<Boolean> {
        private static final Logger log = LoggerFactory.getLogger(GraphCacheEvictionCompleteTrigger.class);
        private final String graphName;

        private GraphCacheEvictionCompleteTrigger(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public Boolean call() {
            log.info("Graph {} has been removed from the graph cache on every JanusGraph node in the cluster.", (Object)this.graphName);
            return true;
        }
    }

    private class IndexBuilder
    implements JanusGraphManagement.IndexBuilder {
        private final String indexName;
        private final ElementCategory elementCategory;
        private boolean unique = false;
        private JanusGraphSchemaType constraint = null;
        private final Map<PropertyKey, Parameter[]> keys = new HashMap<PropertyKey, Parameter[]>();
        private final Set<PropertyKey> inlinePropKeys = new HashSet<PropertyKey>();

        private IndexBuilder(String indexName, ElementCategory elementCategory) {
            this.indexName = indexName;
            this.elementCategory = elementCategory;
        }

        @Override
        public JanusGraphManagement.IndexBuilder addKey(PropertyKey key) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object)key);
            this.keys.put(key, null);
            return this;
        }

        @Override
        public JanusGraphManagement.IndexBuilder addKey(PropertyKey key, Parameter ... parameters) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object)key);
            this.keys.put(key, parameters);
            return this;
        }

        @Override
        public JanusGraphManagement.IndexBuilder addInlinePropertyKey(PropertyKey key) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object)key);
            this.inlinePropKeys.add(key);
            return this;
        }

        @Override
        public JanusGraphManagement.IndexBuilder indexOnly(JanusGraphSchemaType schemaType) {
            Preconditions.checkNotNull((Object)schemaType);
            Preconditions.checkArgument((boolean)this.elementCategory.isValidConstraint(schemaType), (String)"Need to specify a valid schema type for this index definition: %s", (Object)schemaType);
            this.constraint = schemaType;
            return this;
        }

        @Override
        public JanusGraphManagement.IndexBuilder unique() {
            this.unique = true;
            return this;
        }

        @Override
        public JanusGraphIndex buildCompositeIndex() {
            Preconditions.checkArgument((!this.keys.isEmpty() ? 1 : 0) != 0, (Object)"Need to specify at least one key for the composite index");
            PropertyKey[] keyArr = new PropertyKey[this.keys.size()];
            int pos = 0;
            for (Map.Entry<PropertyKey, Parameter[]> entry : this.keys.entrySet()) {
                Preconditions.checkArgument((entry.getValue() == null ? 1 : 0) != 0, (String)"Cannot specify parameters for composite index: %s", (Object)entry.getKey());
                keyArr[pos++] = entry.getKey();
            }
            return ManagementSystem.this.createCompositeIndex(this.indexName, this.elementCategory, this.unique, this.constraint, this.inlinePropKeys, keyArr);
        }

        @Override
        public JanusGraphIndex buildMixedIndex(String backingIndex) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)backingIndex), (Object)"Need to specify backing index name");
            Preconditions.checkArgument((!this.unique ? 1 : 0) != 0, (Object)"An external index cannot be unique");
            Preconditions.checkArgument((boolean)this.inlinePropKeys.isEmpty(), (Object)"An external index cannot contain inline properties");
            JanusGraphIndex index = ManagementSystem.this.createMixedIndex(this.indexName, this.elementCategory, this.constraint, backingIndex);
            for (Map.Entry<PropertyKey, Parameter[]> entry : this.keys.entrySet()) {
                ManagementSystem.this.addIndexKey(index, entry.getKey(), entry.getValue());
            }
            return index;
        }
    }
}

